/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSpherePlugin;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destroyer
extends Builder {
    private final String vm;
    private final String serverName;
    private final boolean failOnNoExist;
    private final int serverHash;
    private VSphere vsphere = null;

    @DataBoundConstructor
    public Destroyer(String serverName, String vm, boolean failOnNoExist) throws VSphereException {
        this.serverName = serverName;
        this.failOnNoExist = failOnNoExist;
        this.vm = vm;
        this.serverHash = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).getHash();
    }

    public String getVm() {
        return this.vm;
    }

    public boolean isFailOnNoExist() {
        return this.failOnNoExist;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, Messages.console_usingServerConfig(this.serverName));
        boolean killed = false;
        try {
            this.vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByHash(this.serverHash).vSphereInstance();
            if (VSpherePlugin.DescriptorImpl.allowDelete()) {
                killed = this.killVm(build, launcher, listener);
            } else {
                VSphereLogger.vsLogger(jLogger, "Deletion is disabled!");
            }
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
            e.printStackTrace(jLogger);
        }
        return killed;
    }

    private boolean killVm(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        VSphereLogger.vsLogger(jLogger, "Destroying VM \"" + expandedVm + ".\" Please wait ...");
        this.vsphere.destroyVm(expandedVm, this.failOnNoExist);
        VSphereLogger.vsLogger(jLogger, "Destroyed!");
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return VSphere.vSphereOutput(Messages.vm_title_Destroyer());
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                if (vsphere.getVmByName(vm) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ListBoxModel doFillServerNameItems() {
            return VSpherePlugin.DescriptorImpl.get().doFillServerItems();
        }
    }
}

