/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSpherePlugin;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkTemplate
extends Builder {
    private final String vm;
    private final boolean force;
    private final String serverName;
    private final String description;
    private final int serverHash;
    private VSphere vsphere = null;

    @DataBoundConstructor
    public MarkTemplate(String serverName, String vm, String description, boolean force) throws VSphereException {
        this.serverName = serverName;
        this.force = force;
        this.vm = vm;
        this.description = description;
        this.serverHash = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).getHash();
    }

    public String getVm() {
        return this.vm;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Attempting to use server configuration: " + this.serverName);
        boolean changed = false;
        try {
            this.vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByHash(this.serverHash).vSphereInstance();
            changed = this.markTemplate(build, launcher, listener);
        }
        catch (VSphereException e) {
            VSphereLogger.vsLogger(jLogger, e.getMessage());
            e.printStackTrace(jLogger);
        }
        return changed;
    }

    private boolean markTemplate(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        VSphereLogger.vsLogger(jLogger, "Converting VM to template. Please wait ...");
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aaa");
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        this.vsphere.markAsTemplate(expandedVm, df.format(date), env.expand(this.description), this.force);
        VSphereLogger.vsLogger(jLogger, "\"" + expandedVm + "\" is now a template.");
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return VSphere.vSphereOutput(Messages.vm_title_MarkTemplate());
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please enter the VM name");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                VSphere vsphere = VSpherePlugin.DescriptorImpl.get().getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)"Specified VM not found!");
                }
                return FormValidation.ok((String)"Success");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillServerNameItems() {
            return VSpherePlugin.DescriptorImpl.get().doFillServerItems();
        }
    }
}

