/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;

@Extension
public class VSpherePlugin
extends Builder {
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static boolean ALLOW_VM_DELETE = true;

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public String getDisplayName() {
            return null;
        }

        public DescriptorImpl() {
            this.load();
        }

        public vSphereCloud getVSphereCloudByName(String serverName) throws RuntimeException, VSphereException {
            if (serverName != null) {
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof vSphereCloud) || !((vSphereCloud)cloud).getVsDescription().equals(serverName)) continue;
                    return (vSphereCloud)cloud;
                }
            }
            throw new RuntimeException("Could not find our vSphere Cloud instance!");
        }

        public vSphereCloud getVSphereCloudByHash(int hash) throws RuntimeException, VSphereException {
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud) || ((vSphereCloud)cloud).getHash() != hash) continue;
                return (vSphereCloud)cloud;
            }
            throw new RuntimeException("Server does not exist in global config! Please re-save your job configuration.");
        }

        public ListBoxModel doFillServerItems() {
            ListBoxModel select = new ListBoxModel();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud)) continue;
                select.add(((vSphereCloud)cloud).getVsDescription());
            }
            return select;
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Builder.all().get(DescriptorImpl.class));
        }

        public static boolean allowDelete() {
            return ALLOW_VM_DELETE;
        }
    }
}

