/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.vSphereCloud;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vSphereCloudLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(vSphereCloudLauncher.class.getName());
    private ComputerLauncher delegate;
    private Boolean overrideLaunchSupported;
    private String vsDescription;
    private String vmName;
    private Boolean waitForVMTools;
    private String snapName;
    private Boolean isStarting = Boolean.FALSE;
    private Boolean isDisconnecting;
    private int launchDelay;
    private MACHINE_ACTION idleAction;

    @DataBoundConstructor
    public vSphereCloudLauncher(ComputerLauncher delegate, String vsDescription, String vmName, Boolean overrideLaunchSupported, Boolean waitForVMTools, String snapName, String launchDelay, String idleOption) {
        this.delegate = delegate;
        this.overrideLaunchSupported = overrideLaunchSupported;
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.waitForVMTools = waitForVMTools;
        this.snapName = snapName;
        this.isStarting = Boolean.FALSE;
        this.launchDelay = Util.tryParseNumber((String)launchDelay, (Number)60).intValue();
        this.idleAction = "Shutdown".equals(idleOption) ? MACHINE_ACTION.SHUTDOWN : ("Shutdown and Revert".equals(idleOption) ? MACHINE_ACTION.REVERT : MACHINE_ACTION.SUSPEND);
    }

    public vSphereCloud findOurVsInstance() throws RuntimeException {
        if (this.vsDescription != null && this.vmName != null) {
            vSphereCloud vs = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud) || !((vSphereCloud)cloud).getVsDescription().equals(this.vsDescription)) continue;
                vs = (vSphereCloud)cloud;
                return vs;
            }
        }
        LOGGER.log(Level.SEVERE, "Could not find our vSphere Cloud instance!");
        throw new RuntimeException("Could not find our vSphere Cloud instance!");
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        try {
            if (slaveComputer.isTemporarilyOffline()) {
                taskListener.getLogger().println("Not launching VM because it's not accepting tasks");
                return;
            }
            if (this.isStarting == Boolean.TRUE) {
                return;
            }
            taskListener.getLogger().println("Starting Virtual Machine...");
            this.isStarting = Boolean.TRUE;
            vSphereCloud vsC = this.findOurVsInstance();
            try {
                ServiceInstance si = vsC.getSI();
                Folder rootFolder = si.getRootFolder();
                VirtualMachine vm = (VirtualMachine)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("VirtualMachine", this.vmName);
                if (vm == null) {
                    throw new IOException("Virtual Machine could not be found");
                }
                if (!this.snapName.isEmpty()) {
                    VirtualMachineSnapshot snap = vsC.getSnapshotInTree(vm, this.snapName);
                    if (snap == null) {
                        throw new IOException("Virtual Machine snapshot cannot be found");
                    }
                    taskListener.getLogger().println("Reverting to snapshot:" + this.snapName);
                    Task task = snap.revertToSnapshot_Task(null);
                    if (!task.waitForTask().equals("success")) {
                        throw new IOException("Error while reverting to virtual machine snapshot");
                    }
                }
                switch (vm.getRuntime().powerState) {
                    case poweredOn: {
                        taskListener.getLogger().println("VM already powered on");
                        break;
                    }
                    case poweredOff: 
                    case suspended: {
                        taskListener.getLogger().println("Powering on VM");
                        Task task = vm.powerOnVM_Task(null);
                        if (task.waitForTask().equals("success")) break;
                        throw new IOException("Unable to power on VM");
                    }
                }
                if (this.waitForVMTools.booleanValue()) {
                    taskListener.getLogger().println("Waiting for VMTools");
                    Calendar target = Calendar.getInstance();
                    target.add(13, 120);
                    while (Calendar.getInstance().before(target)) {
                        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
                        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
                            taskListener.getLogger().println("VM Tools are running");
                            break;
                        }
                        Thread.sleep(5000L);
                    }
                    taskListener.getLogger().println("Finished wait for VMTools");
                }
                Thread.sleep(this.launchDelay * 1000);
                this.delegate.launch(slaveComputer, taskListener);
            }
            catch (Exception e) {
                vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
                throw new RuntimeException(e);
            }
            finally {
                this.isStarting = Boolean.FALSE;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        if (this.isDisconnecting == Boolean.TRUE) {
            taskListener.getLogger().println("Already disconnecting on a separate thread");
            return;
        }
        if (slaveComputer.isTemporarilyOffline()) {
            taskListener.getLogger().println("Not disconnecting VM because it's not accepting tasks");
            return;
        }
        try {
            this.isDisconnecting = Boolean.TRUE;
            taskListener.getLogger().println("Running disconnect procedure...");
            this.delegate.afterDisconnect(slaveComputer, taskListener);
            taskListener.getLogger().println("Shutting down Virtual Machine...");
            MACHINE_ACTION localIdle = this.idleAction;
            if (localIdle == null) {
                localIdle = MACHINE_ACTION.SHUTDOWN;
            }
            vSphereCloud vsC = this.findOurVsInstance();
            vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
            ServiceInstance si = vsC.getSI();
            Folder rootFolder = si.getRootFolder();
            VirtualMachine vm = (VirtualMachine)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("VirtualMachine", this.vmName);
            if (vm != null && vm.getRuntime().powerState == VirtualMachinePowerState.poweredOn) {
                Task task;
                switch (localIdle) {
                    case SHUTDOWN: 
                    case REVERT: {
                        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
                        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
                            taskListener.getLogger().println("Attempting a graceful shutdown");
                            vm.shutdownGuest();
                            Calendar target = Calendar.getInstance();
                            target.add(12, 3);
                            while (Calendar.getInstance().before(target)) {
                                if (vm.getRuntime().powerState == VirtualMachinePowerState.poweredOff) {
                                    taskListener.getLogger().println("Guest shutdown succeeded");
                                    break;
                                }
                                Thread.sleep(5000L);
                            }
                        }
                        if (vm.getRuntime().powerState != VirtualMachinePowerState.poweredOn) break;
                        taskListener.getLogger().println("Powering down hard");
                        task = vm.powerOffVM_Task();
                        if (task.waitForTask().equals("success")) break;
                        taskListener.getLogger().println("Unable to power down the VM");
                        break;
                    }
                    case SUSPEND: {
                        task = vm.suspendVM_Task();
                        if (task.waitForTask().equals("success")) break;
                        taskListener.getLogger().println("Unable to susped the VM");
                    }
                }
                if (localIdle == MACHINE_ACTION.REVERT) {
                    if (!this.snapName.isEmpty()) {
                        VirtualMachineSnapshot snap = vsC.getSnapshotInTree(vm, this.snapName);
                        if (snap == null) {
                            throw new IOException("Virtual Machine snapshot cannot be found");
                        }
                        taskListener.getLogger().println("Reverting to snapshot:" + this.snapName);
                        task = snap.revertToSnapshot_Task(null);
                        if (!task.waitForTask().equals("success")) {
                            throw new IOException("Error while reverting to virtual machine snapshot");
                        }
                    } else {
                        taskListener.getLogger().println("Reverting to current snapshot");
                        Task task2 = vm.revertToCurrentSnapshot_Task(null);
                        if (!task2.waitForTask().equals("success")) {
                            throw new IOException("Error while reverting to virtual machine snapshot");
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            taskListener.getLogger().println("Got an exception");
            taskListener.getLogger().print(t.toString());
            taskListener.getLogger().println("Printed exception");
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
        finally {
            this.isDisconnecting = Boolean.FALSE;
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public MACHINE_ACTION getIdleAction() {
        return this.idleAction;
    }

    public void setIdleAction(MACHINE_ACTION idleAction) {
        this.idleAction = idleAction;
    }

    public Boolean getOverrideLaunchSupported() {
        return this.overrideLaunchSupported;
    }

    public void setOverrideLaunchSupported(Boolean overrideLaunchSupported) {
        this.overrideLaunchSupported = overrideLaunchSupported;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public boolean isLaunchSupported() {
        if (this.overrideLaunchSupported == null) {
            return this.delegate.isLaunchSupported();
        }
        LOGGER.log(Level.FINE, "Launch support is overridden to always return: " + this.overrideLaunchSupported);
        return this.overrideLaunchSupported;
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MACHINE_ACTION {
        SHUTDOWN,
        REVERT,
        SUSPEND;

    }
}

