/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics.util;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.jenkinsci.plugins.vs_code_metrics.Messages;
import org.jenkinsci.plugins.vs_code_metrics.bean.AbstractBean;
import org.jenkinsci.plugins.vs_code_metrics.bean.CodeMetrics;
import org.jenkinsci.plugins.vs_code_metrics.bean.Member;
import org.jenkinsci.plugins.vs_code_metrics.bean.Metrics;
import org.jenkinsci.plugins.vs_code_metrics.bean.Module;
import org.jenkinsci.plugins.vs_code_metrics.bean.Namespace;
import org.jenkinsci.plugins.vs_code_metrics.bean.Type;
import org.jenkinsci.plugins.vs_code_metrics.util.ReportConverter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeMetricsUtil {
    private static final String[] ATTRIBUTE_NAMES = new String[]{"name", "mi", "cyc", "cls", "doi", "loc"};
    private static final String[] PROPERTIES_NAMES = new String[]{"name", "maintainabilityIndex", "cyclomaticComplexity", "classCoupling", "depthOfInheritance", "linesOfCode"};

    private CodeMetricsUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeMetrics createCodeMetrics(FilePath path) throws IOException, InterruptedException {
        InputStream stream = null;
        try {
            CodeMetrics bean;
            stream = path.read();
            Digester digester = new Digester();
            digester.setClassLoader(CodeMetrics.class.getClassLoader());
            digester.addObjectCreate("*/report", CodeMetrics.class);
            digester.addObjectCreate("*/module", Module.class);
            digester.addSetNext("*/module", "addChild");
            digester.addSetProperties("*/module", ATTRIBUTE_NAMES, PROPERTIES_NAMES);
            digester.addObjectCreate("*/namespace", Namespace.class);
            digester.addSetNext("*/namespace", "addChild");
            digester.addSetProperties("*/namespace", ATTRIBUTE_NAMES, PROPERTIES_NAMES);
            digester.addObjectCreate("*/type", Type.class);
            digester.addSetNext("*/type", "addChild");
            digester.addSetProperties("*/type", ATTRIBUTE_NAMES, PROPERTIES_NAMES);
            digester.addObjectCreate("*/member", Member.class);
            digester.addSetNext("*/member", "addChild");
            digester.addSetProperties("*/member", ATTRIBUTE_NAMES, PROPERTIES_NAMES);
            CodeMetrics codeMetrics = bean = (CodeMetrics)digester.parse(stream);
            return codeMetrics;
        }
        catch (SAXException e) {
            CodeMetrics codeMetrics = null;
            return codeMetrics;
        }
        catch (IOException e) {
            CodeMetrics codeMetrics = null;
            return codeMetrics;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static File getReportDir(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "vs_code_metrics");
    }

    public static FilePath[] getReports(File file) throws IOException, InterruptedException {
        FilePath[] filePathArray;
        FilePath path = new FilePath(file);
        if (path.isDirectory()) {
            return path.list("*xml");
        }
        FilePath report = new FilePath(new File(path.getName() + ".xml"));
        if (report.exists()) {
            FilePath[] filePathArray2 = new FilePath[1];
            filePathArray = filePathArray2;
            filePathArray2[0] = report;
        } else {
            filePathArray = new FilePath[]{};
        }
        return filePathArray;
    }

    public static CodeMetrics getCodeMetrics(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        File reportFolder = CodeMetricsUtil.getReportDir(build);
        FilePath[] reports = CodeMetricsUtil.getReports(reportFolder);
        Metrics total = null;
        for (FilePath report : reports) {
            CodeMetrics bean = CodeMetricsUtil.createCodeMetrics(report);
            if (bean == null) continue;
            if (total != null) {
                for (Map.Entry entry : bean.getChildren().entrySet()) {
                    if (((AbstractBean)total).getChildren().containsKey(entry.getKey())) continue;
                    ((AbstractBean)total).addChild((Metrics)entry.getValue());
                }
                continue;
            }
            total = bean;
        }
        total.setName(Messages.Summart_AllClasses());
        if (((AbstractBean)total).getChildren().size() > 0) {
            int sumMaintainabilityIndex = 0;
            int sumCyclomaticComplexity = 0;
            int sumClassCoupling = 0;
            int sumDepthOfInheritance = 0;
            int sumtLinesOfCode = 0;
            for (Module module : ((AbstractBean)total).getChildren().values()) {
                sumMaintainabilityIndex += module.getMaintainabilityIndex();
                sumCyclomaticComplexity += module.getCyclomaticComplexity();
                sumClassCoupling += module.getClassCoupling();
                sumDepthOfInheritance += module.getDepthOfInheritance();
                sumtLinesOfCode += module.getLinesOfCode();
            }
            total.setMaintainabilityIndex(sumMaintainabilityIndex / ((AbstractBean)total).getChildren().size());
            total.setCyclomaticComplexity(sumCyclomaticComplexity);
            total.setClassCoupling(sumClassCoupling);
            total.setDepthOfInheritance(sumDepthOfInheritance);
            total.setLinesOfCode(sumtLinesOfCode);
        }
        return total;
    }

    public static FilePath[] locateReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(includes);
            if (ret.length > 0) {
                return ret;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/metrics*.xml")));
                continue;
            }
            files.add(src);
        }
        return files.toArray(new FilePath[files.size()]);
    }

    public static boolean saveReports(FilePath folder, FilePath[] files) throws IOException, InterruptedException {
        boolean r = true;
        ReportConverter converter = new ReportConverter();
        folder.mkdirs();
        for (int i = 0; i < files.length; ++i) {
            String name = "metrics" + (i > 0 ? Integer.valueOf(i) : "") + ".xml";
            FilePath src = files[i];
            FilePath dst = folder.child(name);
            if (converter.convertFile(src.read(), new File(dst.getRemote()))) continue;
            r = false;
        }
        return r;
    }

    public static AbstractBean<?> searchBean(AbstractBean<?> bean, String[] tokens) {
        return CodeMetricsUtil.searchBean(bean, tokens, 0);
    }

    public static AbstractBean<?> searchBean(AbstractBean<?> bean, String[] tokens, int index) {
        if (tokens.length <= index) {
            return bean;
        }
        if (!bean.getChildren().containsKey(tokens[index])) {
            return null;
        }
        return CodeMetricsUtil.searchBean((AbstractBean)bean.getChildren().get(tokens[index]), tokens, index + 1);
    }
}

