/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.vs_code_metrics.Messages;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsBuildAction;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsProjectAction;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsThresholds;
import org.jenkinsci.plugins.vs_code_metrics.util.CodeMetricsUtil;
import org.jenkinsci.plugins.vs_code_metrics.util.StringUtil;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsCodeMetricsPublisher
extends Recorder {
    private final String reportFiles;
    private final VsCodeMetricsThresholds thresholds;
    private final boolean failBuild;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VsCodeMetricsPublisher(String reportFiles, int minMaintainabilityIndex, int maxMaintainabilityIndex, boolean failBuild) {
        this.reportFiles = reportFiles;
        this.failBuild = failBuild;
        this.thresholds = minMaintainabilityIndex >= maxMaintainabilityIndex ? new VsCodeMetricsThresholds(10, 20) : new VsCodeMetricsThresholds(minMaintainabilityIndex, maxMaintainabilityIndex);
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public int getMinMaintainabilityIndex() {
        return this.thresholds.getMinMaintainabilityIndex();
    }

    public int getMaxMaintainabilityIndex() {
        return this.thresholds.getMaxMaintainabilityIndex();
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (StringUtil.isNullOrSpace(this.reportFiles)) {
            return false;
        }
        PrintStream logger = listener.getLogger();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        String includes = env.expand(this.reportFiles);
        logger.println("Code Metrics Report path: " + includes);
        FilePath[] reports = CodeMetricsUtil.locateReports(build.getWorkspace(), includes);
        if (reports.length == 0) {
            if (build.getResult().isWorseThan(Result.UNSTABLE)) {
                return true;
            }
            logger.println("Code Metrics Report Not Found.");
            build.setResult(this.failBuild ? Result.FAILURE : Result.UNSTABLE);
            return true;
        }
        FilePath metricsFolder = new FilePath(CodeMetricsUtil.getReportDir(build));
        if (!CodeMetricsUtil.saveReports(metricsFolder, reports)) {
            logger.println("Code Metrics Report Convert Error.");
            build.setResult(this.failBuild ? Result.FAILURE : Result.UNSTABLE);
            return true;
        }
        VsCodeMetricsBuildAction action = new VsCodeMetricsBuildAction(build, this.thresholds);
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new VsCodeMetricsProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(VsCodeMetricsPublisher.class);
        }

        public String getDisplayName() {
            return Messages.VsCodeMetricsPublisher_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

