/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.io.IOException;
import org.jenkinsci.plugins.vs_code_metrics.MaintainabilityIndexGraph;
import org.jenkinsci.plugins.vs_code_metrics.Messages;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsBuildAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsCodeMetricsProjectAction
implements Action {
    public final AbstractProject<?, ?> project;

    public VsCodeMetricsProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.VsCodeMetricsProjectAction_DisplayName();
    }

    public String getUrlName() {
        return "vs_code_metrics";
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(VsCodeMetricsBuildAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public VsCodeMetricsBuildAction getLastFinishedBuildAction() {
        AbstractBuild<?, ?> lastBuild = this.getLastFinishedBuild();
        return lastBuild != null ? (VsCodeMetricsBuildAction)lastBuild.getAction(VsCodeMetricsBuildAction.class) : null;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild<?, ?> build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), "vs_code_metrics"));
        }
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        MaintainabilityIndexGraph graph = new MaintainabilityIndexGraph((AbstractBuild)this.project.getLastBuild(), new String[0], ((AbstractBuild)this.project.getLastBuild()).getTimestamp(), 500, 200);
        graph.doPng(req, rsp);
    }
}

