/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.Serializable;
import jenkins.model.RunAction2;
import org.jenkinsci.plugins.vmanager.PostActionBase;
import org.jenkinsci.plugins.vmanager.ReportManager;
import org.jenkinsci.plugins.vmanager.SummaryReportParams;
import org.jenkinsci.plugins.vmanager.VAPIConnectionParam;

public class ReportBuildAction
extends PostActionBase
implements Serializable,
RunAction2 {
    private transient Run<?, ?> build;
    private transient TaskListener listener;
    private transient ReportManager reportManager;

    public String getIconFileName() {
        return "/plugin/vmanager-plugin/img/report.png";
    }

    public String getDisplayName() {
        return "vManager Summary Report";
    }

    public String getUrlName() {
        return "vManagerSummaryReport";
    }

    public int getBuildNumber() {
        return this.build.number;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public ReportBuildAction(Run<?, ?> run, SummaryReportParams summaryReportParams, VAPIConnectionParam vAPIConnectionParam, TaskListener taskListener) {
        this.build = run;
        this.listener = taskListener;
        this.reportManager = new ReportManager(run, summaryReportParams, vAPIConnectionParam, taskListener);
        try {
            boolean bl = false;
            if ("stream".equals(summaryReportParams.vManagerVersion)) {
                bl = true;
            }
            this.reportManager.retrievReportFromServer(bl);
            this.reportManager.emailSummaryReport();
        }
        catch (Exception exception) {
            taskListener.getLogger().println("Failed to get summary report from server");
            exception.printStackTrace();
        }
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }

    public String getReportFromWorkspace() {
        ReportManager reportManager = new ReportManager(this.build, null, null, this.listener);
        return reportManager.getReportFromWorkspace();
    }
}

