/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl.post;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.RunList;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.vmanager.PostActionBase;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.jenkinsci.plugins.vmanager.dsl.post.DSLBuildAction;

public class DSLProjectAction
extends PostActionBase
implements Serializable,
Action {
    private transient Job<?, ?> project;

    public String getIconFileName() {
        return "/plugin/vmanager-plugin/img/project_icon.png";
    }

    public String getDisplayName() {
        return "vManager Jobs Overview";
    }

    public String getUrlName() {
        return "VMGRBuildView";
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public String getProjectName() {
        if (this.project == null) {
            return "Error - Project name was not set yet.  Please run build at least once after a Jenkins restart";
        }
        return this.project.getName();
    }

    public List<VMGRRun> getFinishedVMGRBuilds() {
        ArrayList<VMGRRun> arrayList = new ArrayList<VMGRRun>();
        if (this.project == null) {
            return arrayList;
        }
        RunList runList = this.project.getBuilds();
        Class<DSLBuildAction> clazz = DSLBuildAction.class;
        VMGRRun vMGRRun = null;
        Job job = null;
        String string = null;
        int n = 0;
        for (Run run : runList) {
            if (n == 15) break;
            try {
                job = run.getParent();
                string = job.getBuildDir().getAbsolutePath() + File.separator + run.getNumber();
                vMGRRun = new VMGRRun(run, string, job.getBuildDir().getAbsolutePath());
                arrayList.add(vMGRRun);
                ++n;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return arrayList;
    }

    DSLProjectAction(Job<?, ?> job) {
        this.project = job;
    }
}

