/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl;

import com.google.common.collect.ImmutableSet;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.dsl.VMGRLaunchStepImpl;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class VMGRLaunchStep
extends Step {
    private final String vAPIUrl;
    private final boolean authRequired;
    private final boolean advConfig;
    private final String vAPIUser;
    private final String vAPIPassword;
    private final String vSIFName;
    private final String vSIFInputFile;
    private final String credentialInputFile;
    private final boolean deleteInputFile;
    private final boolean deleteCredentialInputFile;
    private final boolean useUserOnFarm;
    private final boolean dynamicUserId;
    private final String vsifType;
    private final String userFarmType;
    private final String envSourceInputFile;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private final boolean envVarible;
    private final String envVaribleFile;
    private final boolean attrValues;
    private final String attrValuesFile;
    private final boolean pipelineNodes;
    private final String masterWorkspaceLocation;
    private final String inaccessibleResolver;
    private final String stoppedResolver;
    private final String failedResolver;
    private final String doneResolver;
    private final String suspendedResolver;
    private final boolean waitTillSessionEnds;
    private int stepSessionTimeout = 0;
    private final boolean generateJUnitXML;
    private final boolean extraAttributesForFailures;
    private final String staticAttributeList;
    private final boolean markBuildAsFailedIfAllRunFailed;
    private final boolean failJobIfAllRunFailed;
    private final boolean markBuildAsPassedIfAllRunPassed;
    private final boolean failJobUnlessAllRunPassed;
    private final boolean userPrivateSSHKey;
    private final boolean vMGRBuildArchive;
    private final boolean deleteAlsoSessionDirectory;
    private final boolean genericCredentialForSessionDelete;
    private final String archiveUser;
    private final String archivePassword;
    private final String famMode;
    private final String famModeLocation;
    private final boolean noAppendSeed;
    private final String executionType;
    private final String sessionsInputFile;
    private final boolean deleteSessionInputFile;

    @DataBoundConstructor
    public VMGRLaunchStep(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string7, String string8, boolean bl5, boolean bl6, int n, int n2, boolean bl7, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl8, int n3, boolean bl9, boolean bl10, String string15, boolean bl11, boolean bl12, String string16, boolean bl13, boolean bl14, boolean bl15, String string17, String string18, String string19, String string20, boolean bl16, boolean bl17, String string21, boolean bl18, boolean bl19, boolean bl20, boolean bl21, String string22, String string23, String string24, boolean bl22) {
        this.vAPIUrl = string;
        this.vAPIUser = string2;
        this.vAPIPassword = string3;
        this.vSIFName = string4;
        this.vSIFInputFile = string5;
        this.credentialInputFile = string6;
        this.authRequired = bl4;
        this.advConfig = bl6;
        this.envVarible = bl7;
        this.attrValues = bl21;
        this.deleteInputFile = bl;
        this.deleteCredentialInputFile = bl2;
        this.useUserOnFarm = bl3;
        this.vsifType = string7;
        this.userFarmType = string8;
        this.dynamicUserId = bl5;
        this.envVaribleFile = string9;
        this.attrValuesFile = string22;
        this.pipelineNodes = bl17;
        this.masterWorkspaceLocation = string21;
        this.envSourceInputFile = string16;
        this.connTimeout = n;
        this.readTimeout = n2;
        this.inaccessibleResolver = string10;
        this.stoppedResolver = string11;
        this.failedResolver = string12;
        this.doneResolver = string13;
        this.suspendedResolver = string14;
        this.waitTillSessionEnds = bl8;
        this.stepSessionTimeout = n3;
        this.generateJUnitXML = bl9;
        this.extraAttributesForFailures = bl10;
        this.markBuildAsFailedIfAllRunFailed = bl11;
        this.failJobIfAllRunFailed = bl12;
        this.markBuildAsPassedIfAllRunPassed = bl18;
        this.failJobUnlessAllRunPassed = bl19;
        this.userPrivateSSHKey = bl20;
        this.staticAttributeList = string15;
        this.vMGRBuildArchive = bl13;
        this.deleteAlsoSessionDirectory = bl14;
        this.genericCredentialForSessionDelete = bl15;
        this.archiveUser = string17;
        this.archivePassword = string18;
        this.famMode = string19;
        this.famModeLocation = string20;
        this.noAppendSeed = bl16;
        this.executionType = string23;
        this.sessionsInputFile = string24;
        this.deleteSessionInputFile = bl22;
    }

    public String getSessionsInputFile() {
        return this.sessionsInputFile;
    }

    public boolean isDeleteSessionInputFile() {
        return this.deleteSessionInputFile;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public boolean isExtraAttributesForFailures() {
        return this.extraAttributesForFailures;
    }

    public boolean isNoAppendSeed() {
        return this.noAppendSeed;
    }

    public boolean isMarkBuildAsFailedIfAllRunFailed() {
        return this.markBuildAsFailedIfAllRunFailed;
    }

    public boolean isFailJobIfAllRunFailed() {
        return this.failJobIfAllRunFailed;
    }

    public boolean isMarkBuildAsPassedIfAllRunPassed() {
        return this.markBuildAsPassedIfAllRunPassed;
    }

    public boolean isFailJobUnlessAllRunPassed() {
        return this.failJobUnlessAllRunPassed;
    }

    public boolean isUserPrivateSSHKey() {
        return this.userPrivateSSHKey;
    }

    public String getStaticAttributeList() {
        return this.staticAttributeList;
    }

    public boolean isGenerateJUnitXML() {
        return this.generateJUnitXML;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public String getVAPIPassword() {
        return this.vAPIPassword;
    }

    public String getVSIFName() {
        return this.vSIFName;
    }

    public String getEnvVaribleFile() {
        return this.envVaribleFile;
    }

    public String getAttrValuesFile() {
        return this.attrValuesFile;
    }

    public String getMasterWorkspaceLocation() {
        return this.masterWorkspaceLocation;
    }

    public String getEnvSourceInputFile() {
        return this.envSourceInputFile;
    }

    public String getVSIFInputFile() {
        return this.vSIFInputFile;
    }

    public String getCredentialInputFile() {
        return this.credentialInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDeleteCredentialInputFile() {
        return this.deleteCredentialInputFile;
    }

    public boolean isUseUserOnFarm() {
        return this.useUserOnFarm;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getVsifType() {
        return this.vsifType;
    }

    public String getUserFarmType() {
        return this.userFarmType;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public boolean isEnvVarible() {
        return this.envVarible;
    }

    public boolean isAttrValues() {
        return this.attrValues;
    }

    public boolean isPipelineNodes() {
        return this.pipelineNodes;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getStepSessionTimeout() {
        return this.stepSessionTimeout;
    }

    public String getInaccessibleResolver() {
        return this.inaccessibleResolver;
    }

    public String getStoppedResolver() {
        return this.stoppedResolver;
    }

    public String getFailedResolver() {
        return this.failedResolver;
    }

    public String getDoneResolver() {
        return this.doneResolver;
    }

    public String getSuspendedResolver() {
        return this.suspendedResolver;
    }

    public boolean isWaitTillSessionEnds() {
        return this.waitTillSessionEnds;
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public String getArchivePassword() {
        return this.archivePassword;
    }

    public String getFamMode() {
        return this.famMode;
    }

    public String getFamModeLocation() {
        return this.famModeLocation;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new VMGRLaunchStepImpl(this, stepContext);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getFunctionName() {
            return "vmanagerLaunch";
        }

        @Nonnull
        public String getDisplayName() {
            return "Cadence vManager Session Launcher";
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String string) throws IOException, ServletException {
            if (string.length() == 0) {
                return FormValidation.error((String)"Please set the vManager vAPI HOST ");
            }
            if (string.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStaticAttributeList(@QueryParameter String string) throws IOException, ServletException {
            if (string != null) {
                if (string.indexOf(";") > 0) {
                    return FormValidation.error((String)"(;) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (string.indexOf("|") > 0) {
                    return FormValidation.error((String)"(|) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (string.indexOf(".") > 0) {
                    return FormValidation.error((String)"(.) is not allowed for seperation.  Please use only comma as a seperator.");
                }
            }
            List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
            Iterator<String> iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = iterator.next();
                if (string2.indexOf(" ") > 0) {
                    return FormValidation.error((String)("'" + string2 + "' is not a valid option for vManager attribute code name. Attribute code names can't have space.  Try using underscore instaed."));
                }
                if (string2.equals("first_failure_name")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("first_failure_description")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("computed_seed")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("test_group")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (!string2.equals("test_name")) continue;
                return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public ListBoxModel doFillInaccessibleResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillStoppedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillFailedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillDoneResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Mark the build as failed", "fail");
            return listBoxModel;
        }

        public ListBoxModel doFillSuspendedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Mark the build as failed", "fail");
            return listBoxModel;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject jSONObject) throws Descriptor.FormException {
            this.save();
            return super.configure(staplerRequest, jSONObject);
        }

        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String string, @QueryParameter(value="vAPIPassword") String string2, @QueryParameter(value="vAPIUrl") String string3, @QueryParameter(value="authRequired") boolean bl) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string4 = utils.checkVAPIConnection(string3, bl, string, string2);
                if (!string4.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string4));
                }
                return FormValidation.error((String)string4);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }

        public FormValidation doTestArchiveUser(@QueryParameter(value="archiveUser") String string, @QueryParameter(value="archivePassword") String string2, @QueryParameter(value="vAPIUrl") String string3) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string4 = utils.checkVAPIConnection(string3, true, string, string2);
                if (!string4.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string4));
                }
                return FormValidation.error((String)string4);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }

        public FormValidation doTestExtraStaticAttr(@QueryParameter(value="vAPIUser") String string, @QueryParameter(value="vAPIPassword") String string2, @QueryParameter(value="vAPIUrl") String string3, @QueryParameter(value="authRequired") boolean bl, @QueryParameter(value="staticAttributeList") String string4) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string5 = utils.checkExtraStaticAttr(string3, bl, string, string2, string4);
                if (!string5.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string5));
                }
                return FormValidation.error((String)string5);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class, EnvVars.class);
        }
    }
}

