/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRBuildArchiver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class VMGRLaunch
extends Builder {
    private final String vAPIUrl;
    private final boolean authRequired;
    private final boolean advConfig;
    private final String vAPIUser;
    private final String vAPIPassword;
    private final String vSIFName;
    private final String vSIFInputFile;
    private final String credentialInputFile;
    private final boolean deleteInputFile;
    private final boolean deleteCredentialInputFile;
    private final boolean useUserOnFarm;
    private final boolean dynamicUserId;
    private final String vsifType;
    private final String userFarmType;
    private final String envSourceInputFile;
    private int connTimeout = 1;
    private int readTimeout = 30;
    private final boolean envVarible;
    private final String envVaribleFile;
    private final boolean attrValues;
    private final String attrValuesFile;
    private final String inaccessibleResolver;
    private final String stoppedResolver;
    private final String failedResolver;
    private final String doneResolver;
    private final String suspendedResolver;
    private final boolean waitTillSessionEnds;
    private int stepSessionTimeout = 0;
    private final boolean generateJUnitXML;
    private final boolean extraAttributesForFailures;
    private final String staticAttributeList;
    private final boolean markBuildAsFailedIfAllRunFailed;
    private final boolean failJobIfAllRunFailed;
    private final boolean markBuildAsPassedIfAllRunPassed;
    private final boolean failJobUnlessAllRunPassed;
    private final boolean userPrivateSSHKey;
    private final boolean vMGRBuildArchive;
    private final boolean deleteAlsoSessionDirectory;
    private final boolean genericCredentialForSessionDelete;
    private final String archiveUser;
    private final String archivePassword;
    private final String famMode;
    private final String famModeLocation;
    private final boolean noAppendSeed;
    private final String executionType;
    private final String sessionsInputFile;
    private final boolean deleteSessionInputFile;

    @DataBoundConstructor
    public VMGRLaunch(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string7, String string8, boolean bl5, boolean bl6, int n, int n2, boolean bl7, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl8, int n3, boolean bl9, boolean bl10, String string15, boolean bl11, boolean bl12, String string16, boolean bl13, boolean bl14, boolean bl15, String string17, String string18, String string19, String string20, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, String string21, String string22, String string23, boolean bl21) {
        this.vAPIUrl = string;
        this.vAPIUser = string2;
        this.vAPIPassword = string3;
        this.vSIFName = string4;
        this.vSIFInputFile = string5;
        this.credentialInputFile = string6;
        this.authRequired = bl4;
        this.advConfig = bl6;
        this.envVarible = bl7;
        this.deleteInputFile = bl;
        this.deleteCredentialInputFile = bl2;
        this.useUserOnFarm = bl3;
        this.vsifType = string7;
        this.userFarmType = string8;
        this.dynamicUserId = bl5;
        this.envVaribleFile = string9;
        this.attrValues = bl20;
        this.attrValuesFile = string21;
        this.envSourceInputFile = string16;
        this.connTimeout = n;
        this.readTimeout = n2;
        this.inaccessibleResolver = string10;
        this.stoppedResolver = string11;
        this.failedResolver = string12;
        this.doneResolver = string13;
        this.suspendedResolver = string14;
        this.waitTillSessionEnds = bl8;
        this.stepSessionTimeout = n3;
        this.generateJUnitXML = bl9;
        this.extraAttributesForFailures = bl10;
        this.markBuildAsFailedIfAllRunFailed = bl11;
        this.failJobIfAllRunFailed = bl12;
        this.markBuildAsPassedIfAllRunPassed = bl17;
        this.failJobUnlessAllRunPassed = bl18;
        this.userPrivateSSHKey = bl19;
        this.staticAttributeList = string15;
        this.vMGRBuildArchive = bl13;
        this.deleteAlsoSessionDirectory = bl14;
        this.genericCredentialForSessionDelete = bl15;
        this.archiveUser = string17;
        this.archivePassword = string18;
        this.famMode = string19;
        this.famModeLocation = string20;
        this.noAppendSeed = bl16;
        this.executionType = string22;
        this.sessionsInputFile = string23;
        this.deleteSessionInputFile = bl21;
    }

    public String getSessionsInputFile() {
        return this.sessionsInputFile;
    }

    public boolean isDeleteSessionInputFile() {
        return this.deleteSessionInputFile;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public boolean isExtraAttributesForFailures() {
        return this.extraAttributesForFailures;
    }

    public boolean isNoAppendSeed() {
        return this.noAppendSeed;
    }

    public boolean isMarkBuildAsFailedIfAllRunFailed() {
        return this.markBuildAsFailedIfAllRunFailed;
    }

    public boolean isFailJobIfAllRunFailed() {
        return this.failJobIfAllRunFailed;
    }

    public boolean isMarkBuildAsPassedIfAllRunPassed() {
        return this.markBuildAsPassedIfAllRunPassed;
    }

    public boolean isFailJobUnlessAllRunPassed() {
        return this.failJobUnlessAllRunPassed;
    }

    public boolean isUserPrivateSSHKey() {
        return this.userPrivateSSHKey;
    }

    public String getStaticAttributeList() {
        return this.staticAttributeList;
    }

    public boolean isGenerateJUnitXML() {
        return this.generateJUnitXML;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public String getVAPIPassword() {
        return this.vAPIPassword;
    }

    public String getVSIFName() {
        return this.vSIFName;
    }

    public String getEnvVaribleFile() {
        return this.envVaribleFile;
    }

    public String getAttrValuesFile() {
        return this.attrValuesFile;
    }

    public String getEnvSourceInputFile() {
        return this.envSourceInputFile;
    }

    public String getVSIFInputFile() {
        return this.vSIFInputFile;
    }

    public String getCredentialInputFile() {
        return this.credentialInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDeleteCredentialInputFile() {
        return this.deleteCredentialInputFile;
    }

    public boolean isUseUserOnFarm() {
        return this.useUserOnFarm;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getVsifType() {
        return this.vsifType;
    }

    public String getUserFarmType() {
        return this.userFarmType;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public boolean isEnvVarible() {
        return this.envVarible;
    }

    public boolean isAttrValues() {
        return this.attrValues;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getStepSessionTimeout() {
        return this.stepSessionTimeout;
    }

    public String getInaccessibleResolver() {
        return this.inaccessibleResolver;
    }

    public String getStoppedResolver() {
        return this.stoppedResolver;
    }

    public String getFailedResolver() {
        return this.failedResolver;
    }

    public String getDoneResolver() {
        return this.doneResolver;
    }

    public String getSuspendedResolver() {
        return this.suspendedResolver;
    }

    public boolean isWaitTillSessionEnds() {
        return this.waitTillSessionEnds;
    }

    public boolean isVMGRBuildArchive() {
        return this.vMGRBuildArchive;
    }

    public boolean isDeleteAlsoSessionDirectory() {
        return this.deleteAlsoSessionDirectory;
    }

    public boolean isGenericCredentialForSessionDelete() {
        return this.genericCredentialForSessionDelete;
    }

    public String getArchiveUser() {
        return this.archiveUser;
    }

    public String getArchivePassword() {
        return this.archivePassword;
    }

    public String getFamMode() {
        return this.famMode;
    }

    public String getFamModeLocation() {
        return this.famModeLocation;
    }

    public boolean perform(AbstractBuild abstractBuild, Launcher launcher, BuildListener buildListener) {
        String string = abstractBuild.getRootDir().getAbsolutePath();
        buildListener.getLogger().println("Root dir is: " + string);
        buildListener.getLogger().println("The HOST for vAPI is: " + this.vAPIUrl);
        buildListener.getLogger().println("The vAPIUser for vAPI is: " + this.vAPIUser);
        buildListener.getLogger().println("The vAPIPassword for vAPI is: *******");
        buildListener.getLogger().println("The authRequired for vAPI is: " + this.authRequired);
        buildListener.getLogger().println("The id is: " + abstractBuild.getId());
        buildListener.getLogger().println("The number is: " + abstractBuild.getNumber());
        buildListener.getLogger().println("The workspace dir is: " + abstractBuild.getWorkspace());
        if (this.advConfig) {
            buildListener.getLogger().println("The connection timeout is: " + this.connTimeout + " minutes");
            buildListener.getLogger().println("The read api timeout is: " + this.readTimeout + " minutes");
        } else {
            buildListener.getLogger().println("The connection timeout is: 1 minutes");
            buildListener.getLogger().println("The read api timeout is: 30 minutes");
        }
        buildListener.getLogger().println("The execution type set is " + this.executionType);
        if ("batch".equals(this.executionType)) {
            buildListener.getLogger().println("The session input file name is: " + this.sessionsInputFile);
            buildListener.getLogger().println("The deleteSessionInputFile : " + this.deleteSessionInputFile);
        } else {
            buildListener.getLogger().println("The vsif to be executed is is " + this.vsifType);
            buildListener.getLogger().println("The vSIFName is: " + this.vSIFName);
            buildListener.getLogger().println("The vSIFPathForExternalVSIF Input is: " + this.vSIFInputFile);
            buildListener.getLogger().println("The deleteInputFile for vAPI is: " + this.deleteInputFile);
            if (this.envVarible) {
                buildListener.getLogger().println("An environment varible file was selected.");
            }
            if (this.attrValues) {
                buildListener.getLogger().println("An attribute values file was selected.");
            }
            if (this.useUserOnFarm) {
                buildListener.getLogger().println("An User's Credential use was selected.");
                buildListener.getLogger().println("The User's Credential type is: " + this.userFarmType);
                buildListener.getLogger().println("User is using private stored SSH key: " + this.userPrivateSSHKey);
                if ("dynamic".equals(this.userFarmType)) {
                    buildListener.getLogger().println("The credential file is: " + this.credentialInputFile);
                    buildListener.getLogger().println("The credential file was set to be deleted after use: " + this.deleteCredentialInputFile);
                }
                if (!"".equals(this.envSourceInputFile.trim())) {
                    buildListener.getLogger().println("The User's source file is: " + this.envSourceInputFile);
                } else {
                    buildListener.getLogger().println("The User's source file wasn't set");
                }
            }
        }
        StepHolder stepHolder = null;
        JUnitRequestHolder jUnitRequestHolder = null;
        if (this.waitTillSessionEnds) {
            buildListener.getLogger().println("Build set to finish only when session finish to run");
            buildListener.getLogger().println("In case session is at state 'inaccessible' the build will " + this.inaccessibleResolver);
            buildListener.getLogger().println("In case session is at state 'failed' the build will " + this.failedResolver);
            buildListener.getLogger().println("In case session is at state 'stopped' the build will " + this.stoppedResolver);
            buildListener.getLogger().println("In case session is at state 'suspended' the build will " + this.suspendedResolver);
            buildListener.getLogger().println("In case session is at state 'done' the build will " + this.doneResolver);
            buildListener.getLogger().println("Timeout for entire step is " + this.stepSessionTimeout + " minutes");
            buildListener.getLogger().println("User choosed to mark regression as Failed in case all runs are failing: " + this.markBuildAsFailedIfAllRunFailed);
            buildListener.getLogger().println("User choosed to fail the job in case all runs are failing: " + this.failJobIfAllRunFailed);
            buildListener.getLogger().println("User choosed to mark regression as Passed in case all runs are passed: " + this.markBuildAsPassedIfAllRunPassed);
            buildListener.getLogger().println("User choosed to fail the job unless all runs are passed: " + this.failJobUnlessAllRunPassed);
            buildListener.getLogger().println("Generate XML Report XML output: " + this.generateJUnitXML);
            if (this.generateJUnitXML) {
                buildListener.getLogger().println("Do not append seed to test names: " + this.noAppendSeed);
                jUnitRequestHolder = new JUnitRequestHolder(this.generateJUnitXML, this.extraAttributesForFailures, this.staticAttributeList, this.noAppendSeed);
                buildListener.getLogger().println("Extra Attributes in JUnit Report: " + this.extraAttributesForFailures);
                if (this.extraAttributesForFailures) {
                    buildListener.getLogger().println("Extra Attributes list in JUnit Report is: " + this.staticAttributeList);
                }
            }
            stepHolder = new StepHolder(this.inaccessibleResolver, this.stoppedResolver, this.failedResolver, this.doneResolver, this.suspendedResolver, this.waitTillSessionEnds, this.stepSessionTimeout, jUnitRequestHolder, this.markBuildAsFailedIfAllRunFailed, this.failJobIfAllRunFailed, this.markBuildAsPassedIfAllRunPassed, this.failJobUnlessAllRunPassed);
        }
        VMGRBuildArchiver vMGRBuildArchiver = null;
        if (this.vMGRBuildArchive) {
            buildListener.getLogger().println("Session was set to get deleted when build is deleted");
            buildListener.getLogger().println("Delete also session directory on disk: " + this.deleteAlsoSessionDirectory);
            buildListener.getLogger().println("Use dedicated credentials for deleting the session: " + this.genericCredentialForSessionDelete);
            buildListener.getLogger().println("Use FAM Mode: " + this.famMode);
            if ("true".equals(this.famMode)) {
                buildListener.getLogger().println("FAM Mode Location: " + this.famModeLocation);
            }
            if (this.genericCredentialForSessionDelete) {
                buildListener.getLogger().println("Dedicated User for session delete: " + this.archiveUser);
                buildListener.getLogger().println("Dedicated password for session delete: *******");
            }
            vMGRBuildArchiver = new VMGRBuildArchiver(this.vMGRBuildArchive, this.deleteAlsoSessionDirectory, this.genericCredentialForSessionDelete, this.archiveUser, this.archivePassword, this.famMode, this.famModeLocation);
        }
        try {
            Utils utils = new Utils();
            String[] stringArray = null;
            String[] stringArray2 = null;
            String string2 = null;
            String string3 = null;
            String[] stringArray3 = null;
            String string4 = this.vAPIUser;
            String string5 = this.vAPIPassword;
            if ("batch".equals(this.executionType)) {
                if (this.sessionsInputFile == null || this.sessionsInputFile.trim().equals("")) {
                    buildListener.getLogger().println("The session input file chosen is dynamic. Dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                } else {
                    buildListener.getLogger().println("The session input file chosen is static. Sessions input file name is: '" + this.sessionsInputFile.trim() + "'");
                }
                stringArray2 = utils.loadDataFromInputFiles(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.sessionsInputFile, (TaskListener)buildListener, this.deleteSessionInputFile, "session names", "sessions.input");
            } else {
                if ("static".equals(this.vsifType)) {
                    buildListener.getLogger().println("The VSIF file chosen is static. VSIF file static location is: '" + this.vSIFName + "'");
                    stringArray = new String[]{this.vSIFName};
                } else {
                    if (this.vSIFInputFile == null || this.vSIFInputFile.trim().equals("")) {
                        buildListener.getLogger().println("The VSIF file chosen is dynamic. VSIF directory dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                    } else {
                        buildListener.getLogger().println("The VSIF file chosen is static. VSIF file name is: '" + this.vSIFInputFile.trim() + "'");
                    }
                    stringArray = utils.loadDataFromInputFiles(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.vSIFInputFile, (TaskListener)buildListener, this.deleteInputFile, "VSIF", "vsif.input");
                }
                if (this.envVarible) {
                    if (this.envVaribleFile == null || this.envVaribleFile.trim().equals("")) {
                        buildListener.getLogger().println("The environment varible file chosen is dynamic. Env File directory dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                    } else {
                        buildListener.getLogger().println("The environment varible file chosen is static. Environment file name is: '" + this.envVaribleFile.trim() + "'");
                    }
                    string2 = utils.loadJSONEnvInput(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.envVaribleFile, (TaskListener)buildListener);
                    buildListener.getLogger().println("Found the following environment for the vsif: " + string2);
                }
                if (this.attrValues) {
                    if (this.attrValuesFile == null || this.attrValuesFile.trim().equals("")) {
                        buildListener.getLogger().println("The attribute values file chosen is dynamic. Env File directory dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                    } else {
                        buildListener.getLogger().println("The attribute values file chosen is static. Attribute values file name is: '" + this.attrValuesFile.trim() + "'");
                    }
                    string3 = utils.loadJSONAttrValuesInput(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.attrValuesFile, (TaskListener)buildListener);
                    buildListener.getLogger().println("Found the following attribute values for the vsif: " + string3);
                }
                if ("dynamic".equals(this.userFarmType)) {
                    if (this.credentialInputFile == null || this.credentialInputFile.trim().equals("")) {
                        buildListener.getLogger().println("The credential file chosen is dynamic. Credential directory dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                    } else {
                        buildListener.getLogger().println("The credential file chosen is static. Credential file name is: '" + this.credentialInputFile.trim() + "'");
                    }
                    stringArray3 = utils.loadFileCredentials(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.credentialInputFile, (TaskListener)buildListener, this.deleteCredentialInputFile);
                    if (this.userPrivateSSHKey) {
                        string4 = stringArray3[0];
                        string5 = stringArray3[1];
                    }
                }
            }
            String string6 = utils.executeVSIFLaunch(stringArray, this.vAPIUrl, this.authRequired, string4, string5, (TaskListener)buildListener, this.dynamicUserId, abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.connTimeout, this.readTimeout, this.advConfig, string2, this.useUserOnFarm, this.userFarmType, stringArray3, stepHolder, this.envSourceInputFile, string, vMGRBuildArchiver, this.userPrivateSSHKey, string3, this.executionType, stringArray2);
            if (!"success".equals(string6)) {
                buildListener.getLogger().println("Failed to launch vsifs for build " + abstractBuild.getId() + " " + abstractBuild.getNumber() + "\n");
                buildListener.getLogger().println(string6 + "\n");
                return false;
            }
        }
        catch (Exception exception) {
            buildListener.getLogger().println("Failed to build " + abstractBuild.getId() + " " + abstractBuild.getNumber());
            buildListener.getLogger().println(exception.getMessage());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                buildListener.getLogger().println(" " + stackTraceElement);
            }
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String string) throws IOException, ServletException {
            if (string.length() == 0) {
                return FormValidation.error((String)"Please set the vManager vAPI HOST ");
            }
            if (string.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckStaticAttributeList(@QueryParameter String string) throws IOException, ServletException {
            if (string != null) {
                if (string.indexOf(";") > 0) {
                    return FormValidation.error((String)"(;) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (string.indexOf("|") > 0) {
                    return FormValidation.error((String)"(|) is not allowed for seperation.  Please use only comma as a seperator.");
                }
                if (string.indexOf(".") > 0) {
                    return FormValidation.error((String)"(.) is not allowed for seperation.  Please use only comma as a seperator.");
                }
            }
            List<String> list = Arrays.asList(string.split("\\s*,\\s*"));
            Iterator<String> iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = iterator.next();
                if (string2.indexOf(" ") > 0) {
                    return FormValidation.error((String)("'" + string2 + "' is not a valid option for vManager attribute code name. Attribute code names can't have space.  Try using underscore instaed."));
                }
                if (string2.equals("first_failure_name")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("first_failure_description")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("computed_seed")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (string2.equals("test_group")) {
                    return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
                }
                if (!string2.equals("test_name")) continue;
                return FormValidation.warning((String)("'" + string2 + "' is already included as part of the stack error message by default."));
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public ListBoxModel doFillInaccessibleResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillStoppedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillFailedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Mark the build as failed", "fail");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            return listBoxModel;
        }

        public ListBoxModel doFillDoneResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Mark the build as failed", "fail");
            return listBoxModel;
        }

        public ListBoxModel doFillSuspendedResolverItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("Ignore, and continue to wait", "ignore");
            listBoxModel.add("Continue, and move to the next build step", "continue");
            listBoxModel.add("Mark the build as failed", "fail");
            return listBoxModel;
        }

        public String getDisplayName() {
            return "Cadence vManager Session Launcher";
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject jSONObject) throws Descriptor.FormException {
            this.save();
            return super.configure(staplerRequest, jSONObject);
        }

        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String string, @QueryParameter(value="vAPIPassword") String string2, @QueryParameter(value="vAPIUrl") String string3, @QueryParameter(value="authRequired") boolean bl) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string4 = utils.checkVAPIConnection(string3, bl, string, string2);
                if (!string4.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string4));
                }
                return FormValidation.error((String)string4);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }

        public FormValidation doTestArchiveUser(@QueryParameter(value="archiveUser") String string, @QueryParameter(value="archivePassword") String string2, @QueryParameter(value="vAPIUrl") String string3) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string4 = utils.checkVAPIConnection(string3, true, string, string2);
                if (!string4.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string4));
                }
                return FormValidation.error((String)string4);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }

        public FormValidation doTestExtraStaticAttr(@QueryParameter(value="vAPIUser") String string, @QueryParameter(value="vAPIPassword") String string2, @QueryParameter(value="vAPIUrl") String string3, @QueryParameter(value="authRequired") boolean bl, @QueryParameter(value="staticAttributeList") String string4) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string5 = utils.checkExtraStaticAttr(string3, bl, string, string2, string4);
                if (!string5.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string5));
                }
                return FormValidation.error((String)string5);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }
    }

    @Extension
    public static final class VMGRDeletedJobListener
    extends RunListener<Run> {
        private static final Logger logger = Logger.getLogger(VMGRDeletedJobListener.class.getName());

        public void onDeleted(Run run) {
            VMGRBuildArchiver vMGRBuildArchiver = new VMGRBuildArchiver();
            try {
                vMGRBuildArchiver.deleteSessions(run, logger);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to delete session during build removal.", exception);
            }
        }
    }
}

