/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.SessionState;
import org.jenkinsci.plugins.vmanager.Utils;

public class SessionStatusHolder {
    String url;
    boolean requireAuth;
    String user;
    String password;
    TaskListener listener;
    boolean dynamicUserId;
    private int buildNumber = 0;
    private String workPlacePath = null;
    private String workingJobDir = null;
    private String buildId = null;
    int connConnTimeOut;
    int connReadTimeout;
    boolean advConfig;
    boolean notInTestMode;
    boolean markBuildAsFailedIfAllRunFailed = false;
    boolean failJobIfAllRunFailed = false;
    boolean markBuildAsPassedIfAllRunPassed = false;
    boolean failJobUnlessAllRunPassed = false;
    List<String> listOfSessions = null;
    private String postDataSessions;
    private String postSessionData = "{\"filter\":{\"@c\":\".ChainedFilter\",\"condition\":\"OR\",\"chain\":[######]},\"grouping\":[\"owner\"],\"settings\":{\"write-hidden\":true,\"stream-mode\":false},\"projection\":{\"type\": \"SELECTION_ONLY\",\"selection\":[\"session_status\",\"name\",\"total_runs_in_session\",\"passed_runs\",\"failed_runs\",\"running\",\"waiting\",\"other_runs\",\"owner\",\"number_of_entities\",\"id\"]}}";

    public SessionStatusHolder(int n, String string, String string2, String string3) {
        this.buildNumber = n;
        this.workPlacePath = string;
        this.workingJobDir = string3;
        this.buildId = string2;
    }

    public SessionStatusHolder(int n, String string, String string2) {
        this.buildNumber = n;
        this.workingJobDir = string;
        this.buildId = string2;
    }

    private void buildPostDataSessionPart(List<String> list) {
        Iterator<String> iterator = list.iterator();
        String string = "";
        int n = list.size() - 1;
        while (iterator.hasNext()) {
            string = string + "{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"" + iterator.next() + "\"}";
            if (n > 0) {
                string = string + ",";
            }
            --n;
        }
        this.postDataSessions = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpSessionStatus(boolean bl, Map<String, String> map) throws Exception {
        HttpURLConnection httpURLConnection = null;
        Utils utils = new Utils();
        String string = this.url + "/rest/sessions/list";
        try {
            httpURLConnection = utils.getVAPIConnection(string, this.requireAuth, this.user, this.password, "POST", this.dynamicUserId, this.buildId, this.buildNumber, this.workPlacePath, this.listener, this.connConnTimeOut, this.connReadTimeout, this.advConfig);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(this.postSessionData.getBytes());
            outputStream.flush();
            if (this.checkResponseCode(httpURLConnection)) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                JSONArray jSONArray = JSONArray.fromObject((Object)stringBuilder.toString());
                Iterator iterator = jSONArray.iterator();
                JSONObject jSONObject = null;
                if (iterator.hasNext()) {
                    jSONObject = (JSONObject)iterator.next();
                }
                this.writeSessionIntoFile(jSONObject, bl, map);
            }
        }
        catch (Exception exception) {
            if ("ALL_RUNS_FAILED".equals(exception.getMessage())) {
                throw new Exception("All runs failed in the regression - marking job as a failed job.\n");
            }
            if ("NOT_ALL_RUNS_PASSED".equals(exception.getMessage())) {
                throw new Exception("Not all runs passed the regression - marking job as a failed job.\n");
            }
            exception.printStackTrace();
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private void writeSessionIntoFile(JSONObject jSONObject, boolean bl, Map<String, String> map) throws IOException, Exception {
        SessionState sessionState = new SessionState();
        if (jSONObject.has("session_status")) {
            if ("MIXED_GROUP_VALUE".equals(jSONObject.getString("session_status"))) {
                sessionState.setStatus("Mixed");
            } else {
                sessionState.setStatus(jSONObject.getString("session_status"));
            }
        }
        if (jSONObject.has("name")) {
            if ("ZZZZZZZZZZZZZZZZ".equals(jSONObject.getString("name"))) {
                sessionState.setName("Mixed");
            } else {
                sessionState.setName(this.cutSessionNameDate(jSONObject.getString("name")));
                sessionState.setSessionCode(this.cutSessionCodeDate(jSONObject.getString("name")));
            }
        }
        if (jSONObject.has("total_runs_in_session")) {
            sessionState.setTotalRuns(jSONObject.getString("total_runs_in_session"));
        }
        if (jSONObject.has("passed_runs")) {
            sessionState.setPassed(jSONObject.getString("passed_runs"));
        }
        if (jSONObject.has("failed_runs")) {
            sessionState.setFailed(jSONObject.getString("failed_runs"));
        }
        if (jSONObject.has("running")) {
            sessionState.setRunning(jSONObject.getString("running"));
        }
        if (jSONObject.has("waiting")) {
            sessionState.setWaiting(jSONObject.getString("waiting"));
        }
        if (jSONObject.has("other_runs")) {
            sessionState.setOther(jSONObject.getString("other_runs"));
        }
        if (jSONObject.has("owner")) {
            if ("ZZZZZZZZZZZZZZZZ".equals(jSONObject.getString("name"))) {
                sessionState.setOwner("Mixed");
            } else {
                sessionState.setOwner(jSONObject.getString("owner"));
            }
        }
        if (jSONObject.has("number_of_entities")) {
            sessionState.setNumOfSession(jSONObject.getString("number_of_entities"));
        }
        if (jSONObject.has("id")) {
            sessionState.setId(jSONObject.getString("id"));
        }
        sessionState.setServerUrl(this.url);
        String string = this.workingJobDir + File.separator + this.buildNumber + "." + this.buildId + ".session_status.properties";
        if (bl) {
            if (this.markBuildAsFailedIfAllRunFailed && sessionState.getTotalRuns().trim().equals(sessionState.getFailed().trim())) {
                sessionState.setStatus("failed");
            }
            if (this.markBuildAsPassedIfAllRunPassed && !sessionState.getTotalRuns().trim().equals(sessionState.getPassed().trim())) {
                sessionState.setStatus("failed");
            }
        }
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.append("status=" + sessionState.getStatus() + "\n");
        fileWriter.append("name=" + sessionState.getName() + "\n");
        fileWriter.append("session_code=" + sessionState.getSessionCode() + "\n");
        fileWriter.append("total_runs_in_session=" + sessionState.getTotalRuns() + "\n");
        fileWriter.append("passed_runs=" + sessionState.getPassed() + "\n");
        fileWriter.append("failed_runs=" + sessionState.getFailed() + "\n");
        fileWriter.append("running=" + sessionState.getRunning() + "\n");
        fileWriter.append("waiting=" + sessionState.getWaiting() + "\n");
        fileWriter.append("other_runs=" + sessionState.getOther() + "\n");
        fileWriter.append("owner=" + sessionState.getOwner() + "\n");
        fileWriter.append("number_of_entities=" + sessionState.getNumOfSession() + "\n");
        Iterator<String> iterator = this.listOfSessions.iterator();
        String string2 = "";
        String string3 = "";
        String string4 = null;
        int n = this.listOfSessions.size() - 1;
        while (iterator.hasNext()) {
            string4 = iterator.next();
            string2 = string2 + string4;
            string3 = string3 + string4 + "$@$" + map.get(string4);
            if (n > 0) {
                string2 = string2 + ",";
                string3 = string3 + ",";
            }
            --n;
        }
        fileWriter.append("id=" + string2 + "\n");
        fileWriter.append("url=" + sessionState.getServerUrl() + "\n");
        fileWriter.append("idNames=" + string3 + "\n");
        fileWriter.flush();
        fileWriter.close();
        String string5 = this.workPlacePath + File.separator + this.buildNumber + "." + this.buildId + ".session_status.properties";
        Path path = FileSystems.getDefault().getPath(string, new String[0]);
        Path path2 = FileSystems.getDefault().getPath(string5, new String[0]);
        Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        if (bl) {
            if (this.failJobIfAllRunFailed && sessionState.getTotalRuns().trim().equals(sessionState.getFailed().trim())) {
                throw new Exception("ALL_RUNS_FAILED");
            }
            if (this.failJobUnlessAllRunPassed && !sessionState.getTotalRuns().trim().equals(sessionState.getPassed().trim())) {
                throw new Exception("NOT_ALL_RUNS_PASSED");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionState loadSessionFromFile() {
        SessionState sessionState = new SessionState();
        String string = this.workingJobDir + File.separator + this.buildNumber + "." + this.buildId + ".session_status.properties";
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            sessionState.setStatus(properties.getProperty("status") != null ? properties.getProperty("status") : "NA");
            sessionState.setName(properties.getProperty("name") != null ? properties.getProperty("name") : "NA");
            sessionState.setSessionCode(properties.getProperty("session_code") != null ? properties.getProperty("session_code") : "NA");
            sessionState.setTotalRuns(properties.getProperty("total_runs_in_session") != null ? properties.getProperty("total_runs_in_session") : "NA");
            sessionState.setPassed(properties.getProperty("passed_runs") != null ? properties.getProperty("passed_runs") : "NA");
            sessionState.setFailed(properties.getProperty("failed_runs") != null ? properties.getProperty("failed_runs") : "NA");
            sessionState.setRunning(properties.getProperty("running") != null ? properties.getProperty("running") : "NA");
            sessionState.setWaiting(properties.getProperty("waiting") != null ? properties.getProperty("waiting") : "NA");
            sessionState.setOther(properties.getProperty("other_runs") != null ? properties.getProperty("other_runs") : "NA");
            sessionState.setOwner(properties.getProperty("owner") != null ? properties.getProperty("owner") : "NA");
            sessionState.setNumOfSession(properties.getProperty("number_of_entities") != null ? properties.getProperty("number_of_entities") : "NA");
            sessionState.setId(properties.getProperty("id") != null ? properties.getProperty("id") : "NA");
            sessionState.setServerUrl(properties.getProperty("url") != null ? properties.getProperty("url") : "NA");
            sessionState.setIdNames(properties.getProperty("idNames") != null ? properties.getProperty("idNames") : "NA");
        }
        catch (IOException iOException) {
            System.out.println("vManager Dashboard - Can't find file " + string);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return sessionState;
    }

    private boolean checkResponseCode(HttpURLConnection httpURLConnection) {
        try {
            if (httpURLConnection.getResponseCode() != 200 && httpURLConnection.getResponseCode() != 204 && httpURLConnection.getResponseCode() != 202 && httpURLConnection.getResponseCode() != 201 && httpURLConnection.getResponseCode() != 206 && httpURLConnection.getResponseCode() != 205 && httpURLConnection.getResponseCode() != 406) {
                System.out.println("Error - Got wrong response from /session/list request for session status - " + httpURLConnection.getResponseCode());
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private String cutSessionNameDate(String string) {
        for (int i = 0; i < 6; ++i) {
            string = string.substring(0, string.lastIndexOf("_"));
        }
        string = string.substring(0, string.lastIndexOf("."));
        string = string.substring(0, string.lastIndexOf("."));
        return string;
    }

    private String cutSessionCodeDate(String string) {
        String string2 = "NA";
        try {
            string2 = string.substring(string.lastIndexOf("_") + 1, string.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public SessionStatusHolder(String string, boolean bl, String string2, String string3, TaskListener taskListener, boolean bl2, int n, String string4, String string5, int n2, int n3, boolean bl3, boolean bl4, List<String> list, boolean bl5, boolean bl6, String string6, boolean bl7, boolean bl8) {
        this.url = string;
        this.requireAuth = bl;
        this.user = string2;
        this.password = string3;
        this.listener = taskListener;
        this.dynamicUserId = bl2;
        this.buildNumber = n;
        this.workPlacePath = string4;
        this.buildId = string5;
        this.connConnTimeOut = n2;
        this.connReadTimeout = n3;
        this.advConfig = bl3;
        this.notInTestMode = bl4;
        this.listOfSessions = list;
        this.markBuildAsFailedIfAllRunFailed = bl5;
        this.failJobIfAllRunFailed = bl6;
        this.workingJobDir = string6;
        this.markBuildAsPassedIfAllRunPassed = bl7;
        this.failJobUnlessAllRunPassed = bl8;
        this.buildPostDataSessionPart(list);
        this.postSessionData = this.postSessionData.replaceAll("######", this.postDataSessions);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int n) {
        this.buildNumber = n;
    }

    public String getWorkspace() {
        return this.workPlacePath;
    }

    public void setWorkPlacePath(String string) {
        this.workPlacePath = string;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String string) {
        this.buildId = string;
    }

    public String getWorkingJobDir() {
        return this.workingJobDir;
    }

    public void setWorkingJobDir(String string) {
        this.workingJobDir = string;
    }
}

