/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.vmanager.BuildStatusMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.jenkinsci.plugins.vmanager.SummaryReportParams;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VAPIConnectionParam;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ReportManager {
    private static final String runsFilter = "{\"filter\":{\"@c\":\".RelationFilter\",\"relationName\":\"session\",\"filter\":{\"@c\":\".ChainedFilter\",\"condition\":\"OR\",\"chain\":[######]}}}";
    private Run<?, ?> build;
    private SummaryReportParams summaryReportParams;
    private VAPIConnectionParam vAPIConnectionParam;
    private VMGRRun vmgrRun;
    private TaskListener listener;
    private boolean testMode = false;

    public ReportManager(Run<?, ?> run, SummaryReportParams summaryReportParams, VAPIConnectionParam vAPIConnectionParam, TaskListener taskListener) {
        this.build = run;
        this.summaryReportParams = summaryReportParams;
        this.vAPIConnectionParam = vAPIConnectionParam;
        this.listener = taskListener;
        Job job = run.getParent();
        String string = job.getBuildDir() + File.separator + run.getNumber();
        this.vmgrRun = new VMGRRun(run, string, job.getBuildDir().getAbsolutePath());
    }

    public ReportManager(SummaryReportParams summaryReportParams, VAPIConnectionParam vAPIConnectionParam, boolean bl) {
        this.testMode = bl;
        this.summaryReportParams = summaryReportParams;
        this.vAPIConnectionParam = vAPIConnectionParam;
    }

    private String buildPostDataSessionFilter() {
        String[] stringArray;
        if (this.testMode) {
            stringArray = new String[]{"1"};
        } else {
            String string = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir() + "", "id", true);
            stringArray = string.split("\\s*,\\s*");
        }
        String string = "";
        int n = stringArray.length - 1;
        for (String string2 : stringArray) {
            string = string + "{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"" + string2.trim() + "\"}";
            if (n > 0) {
                string = string + ",";
            }
            --n;
        }
        return string;
    }

    private String getReportEmailAddresses() {
        Utils utils = new Utils();
        String string = null;
        if ("static".equals(this.summaryReportParams.emailType)) {
            String[] stringArray = this.summaryReportParams.emailList.split(",");
            string = "";
            for (String string2 : stringArray) {
                string = string + "\"" + string2.trim() + "\",";
            }
            if (string.length() > 2) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            try {
                String[] stringArray = utils.loadDataFromInputFiles(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), "" + this.vmgrRun.getJobWorkingDir(), this.summaryReportParams.emailInputFile, this.listener, this.summaryReportParams.deleteEmailInputFile, "emails", "emails.input");
                string = "";
                for (String string3 : stringArray) {
                    string = string + "\"" + string3.trim() + "\",";
                }
                if (string.length() > 2) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            catch (Exception exception) {
                this.listener.getLogger().println("Failed to find the email input file " + this.summaryReportParams.emailInputFile + " or any email file within the workspace for this build.\n " + exception.getMessage());
            }
        }
        return string;
    }

    public String buildPostParamForSummaryReport(boolean bl) throws Exception {
        if (bl) {
            this.listener.getLogger().println("Starting to build the POST API part for sending the report email.");
        } else {
            this.listener.getLogger().println("Starting to build the POST API part for creating summary report.");
        }
        JSONParser jSONParser = new JSONParser();
        String string = "";
        if (this.summaryReportParams.summaryType.equals("wizard")) {
            String string2;
            this.listener.getLogger().println("ReportManager - Using wizrd based json to bring the report...");
            JSONObject jSONObject = null;
            String string3 = "$jenkins_mode\"override\":true,\"sessionsViewName\":\"All_Sessions\",\"linkOutput\":$link_output,\"title\":\"Summary report\",\"includeSessions\":true,\"includeAll\":false$test_view_name$metrics_view_name$vplan_view_name$test_depth";
            if (this.summaryReportParams.runReport) {
                this.summaryReportParams.includeTests = true;
                string2 = ",\"testsDepth\":" + this.summaryReportParams.testsDepth;
                String string4 = ",\"testsViewName\":\"" + this.summaryReportParams.testsViewName.trim() + "\"";
                string3 = string3.replace("$test_depth", string2);
                string3 = string3.replace("$test_view_name", string4);
            } else {
                this.summaryReportParams.includeTests = false;
                string3 = string3.replace("$test_depth", "");
                string3 = string3.replace("$test_view_name", "");
            }
            if (this.summaryReportParams.metricsReport) {
                string2 = ",\"metricsViewName\":\"" + this.summaryReportParams.metricsViewName.trim() + "\"";
                string3 = string3.replace("$metrics_view_name", string2);
            } else {
                string3 = string3.replace("$metrics_view_name", "");
            }
            if (this.summaryReportParams.vPlanReport) {
                string2 = ",\"vplanViewName\":\"" + this.summaryReportParams.vplanViewName.trim() + "\"";
                string3 = string3.replace("$vplan_view_name", string2);
            } else {
                string3 = string3.replace("$vplan_view_name", "");
            }
            if (bl) {
                string3 = string3.replace("$link_output", "false");
                string3 = string3.replace("$jenkins_mode", "");
                string3 = "\"emails\":[" + this.getReportEmailAddresses() + "]," + string3;
            } else {
                string3 = string3.replace("$link_output", "true");
            }
            string3 = "stream".equals(this.summaryReportParams.vManagerVersion) ? string3.replace("$jenkins_mode", "\"jenkins\":true,") : string3.replace("$jenkins_mode", "");
            string = string + "{" + string3 + ",\"includeTests\":" + this.summaryReportParams.includeTests;
            if (this.summaryReportParams.metricsReport) {
                JSONObject jSONObject2;
                string2 = null;
                try {
                    if (this.summaryReportParams.metricsInputType.equals("basic")) {
                        string2 = SummaryReportParams.metricsData;
                        jSONObject2 = (JSONObject)jSONParser.parse(string2);
                        jSONObject2.replace((Object)"depth", (Object)this.summaryReportParams.metricsDepth);
                    } else {
                        string2 = this.summaryReportParams.metricsAdvanceInput.trim();
                        jSONObject2 = (JSONObject)jSONParser.parse(string2);
                    }
                }
                catch (Exception exception) {
                    this.listener.getLogger().println("ReportManager - fail to parse metricsData json input: " + string2);
                    throw exception;
                }
                string = string + ",\"metricsData\":[" + jSONObject2.toJSONString() + "]";
            }
            if (this.summaryReportParams.vPlanReport) {
                JSONObject jSONObject3;
                string2 = null;
                try {
                    if (this.summaryReportParams.vPlanInputType.equals("basic")) {
                        string2 = SummaryReportParams.vPlanData;
                        jSONObject3 = (JSONObject)jSONParser.parse(string2);
                        jSONObject3.replace((Object)"depth", (Object)this.summaryReportParams.vPlanDepth);
                    } else {
                        string2 = this.summaryReportParams.vPlanAdvanceInput.trim();
                        jSONObject3 = (JSONObject)jSONParser.parse(string2);
                    }
                }
                catch (Exception exception) {
                    this.listener.getLogger().println("ReportManager - fail to parse vplanData json input: " + string2);
                    throw exception;
                }
                try {
                    jSONObject = (JSONObject)jSONParser.parse(SummaryReportParams.ctxData);
                    jSONObject.put((Object)"vplanFile", (Object)this.summaryReportParams.vPlanxFileName.trim());
                }
                catch (Exception exception) {
                    this.listener.getLogger().println("ReportManager - fail to parse ctxData json input for vPlan name: " + this.summaryReportParams.vPlanxFileName);
                    throw exception;
                }
                string = string + ",\"vplanData\":[" + jSONObject3.toJSONString() + "]";
            }
            if (this.summaryReportParams.ctxInput) {
                try {
                    jSONObject = (JSONObject)jSONParser.parse(this.summaryReportParams.ctxAdvanceInput);
                    if (this.summaryReportParams.vPlanReport && !this.summaryReportParams.vPlanxFileName.trim().equals("") && !jSONObject.containsKey((Object)"vplanFile")) {
                        jSONObject.put((Object)"vplanFile", (Object)this.summaryReportParams.vPlanxFileName.trim());
                    }
                }
                catch (Exception exception) {
                    this.listener.getLogger().println("ReportManager - fail to parse ctxData json input for vPlan name: " + this.summaryReportParams.vPlanxFileName);
                    throw exception;
                }
                string = string + ",\"ctxData\":" + jSONObject.toJSONString();
            } else if (this.summaryReportParams.vPlanReport) {
                string = string + ",\"ctxData\":" + jSONObject.toJSONString();
            }
            string = string + ",\"rs\":" + runsFilter.replace("######", this.buildPostDataSessionFilter()) + "}";
        } else {
            JSONObject jSONObject;
            JSONObject jSONObject4;
            this.listener.getLogger().println("ReportManager - Using user freestyle json to bring the report...");
            Utils utils = new Utils();
            String string5 = this.testMode ? utils.loadUserSyntaxForSummaryReport("20", 20, "c://temp", this.summaryReportParams.freeVAPISyntax, null, this.summaryReportParams.deleteReportSyntaxInputFile) : utils.loadUserSyntaxForSummaryReport(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), "" + this.vmgrRun.getJobWorkingDir(), this.summaryReportParams.freeVAPISyntax, this.listener, this.summaryReportParams.deleteReportSyntaxInputFile);
            this.listener.getLogger().println("ReportManager - User freestyle syntax is:\n" + string5 + "\n");
            try {
                jSONObject4 = (JSONObject)jSONParser.parse(string5);
            }
            catch (Exception exception) {
                this.listener.getLogger().println("ReportManager - fail to parse user free syntax json input for summary report: " + this.summaryReportParams.vPlanxFileName);
                throw exception;
            }
            try {
                jSONObject = (JSONObject)jSONParser.parse(runsFilter.replace("######", this.buildPostDataSessionFilter()));
            }
            catch (Exception exception) {
                this.listener.getLogger().println("ReportManager - fail to parse rsData for sessions list: " + this.buildPostDataSessionFilter());
                throw exception;
            }
            jSONObject4.put((Object)"rs", (Object)jSONObject);
            if (jSONObject4.containsKey((Object)"jenkins")) {
                jSONObject4.remove((Object)"jenkins");
            }
            if ("stream".equals(this.summaryReportParams.vManagerVersion)) {
                jSONObject4.put((Object)"jenkins", (Object)true);
            }
            if (bl) {
                if (!jSONObject4.containsKey((Object)"emails")) {
                    JSONArray jSONArray = (JSONArray)jSONParser.parse("[" + this.getReportEmailAddresses() + "]");
                    jSONObject4.put((Object)"emails", (Object)jSONArray);
                }
                if (jSONObject4.containsKey((Object)"jenkins")) {
                    jSONObject4.remove((Object)"jenkins");
                }
                if (jSONObject4.containsKey((Object)"linkOutput")) {
                    jSONObject4.remove((Object)"linkOutput");
                }
            }
            string = jSONObject4.toJSONString();
        }
        return string;
    }

    public void fetchFromRemoteURL(String string) throws Exception {
        CharSequence charSequence;
        Object object;
        JSONObject jSONObject;
        JSONParser jSONParser = new JSONParser();
        try {
            jSONObject = (JSONObject)jSONParser.parse(string);
        }
        catch (Exception exception) {
            this.listener.getLogger().println("ReportManager - fail to parse url from /reports/generate-summary-report: " + string);
            throw exception;
        }
        int n = 20;
        String string2 = "20";
        String string3 = "c://temp";
        String string4 = "c://temp";
        if (!this.testMode) {
            n = this.vmgrRun.getRun().getNumber();
            string2 = this.vmgrRun.getRun().getId();
            string3 = this.vmgrRun.getJobWorkingDir();
            string4 = this.build.getRootDir().getAbsolutePath();
        }
        this.fixUntrustCertificate();
        CharSequence charSequence2 = this.vAPIConnectionParam.vAPIUser;
        String string5 = this.vAPIConnectionParam.vAPIUrl + "/rest/reports" + jSONObject.get((Object)"path");
        URL uRL = new URL(string5);
        URLConnection uRLConnection = uRL.openConnection();
        if (this.vAPIConnectionParam.authRequired) {
            Object object2;
            if (this.vAPIConnectionParam.dynamicUserId) {
                object = null;
                try {
                    object2 = new Utils();
                    object = ((Utils)object2).loadFileFromWorkSpace(string2, n, string3, null, this.listener, false, "user.input");
                    charSequence = null;
                    charSequence = ((BufferedReader)object).readLine();
                    if (charSequence != null) {
                        charSequence2 = charSequence;
                    }
                }
                catch (Exception exception) {
                    if (!this.testMode) {
                        this.listener.getLogger().print("Failed to read input file for the dynamic users. \n");
                    } else {
                        System.out.println("Failed to read input file for the dynamic users. \n");
                    }
                    throw exception;
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            object = charSequence2 + ":" + this.vAPIConnectionParam.vAPIPassword;
            object2 = "Basic " + DatatypeConverter.printBase64Binary((byte[])((String)object).getBytes());
            uRLConnection.setRequestProperty("Authorization", (String)object2);
        }
        object = uRLConnection.getInputStream();
        int n2 = 0;
        charSequence = new StringBuffer();
        String string6 = string3 + File.separator + n + "." + string2 + ".summary.report";
        FileWriter fileWriter = new FileWriter(string6);
        while ((n2 = ((InputStream)object).read()) != -1) {
            ((StringBuffer)charSequence).append((char)n2);
        }
        String string7 = ((StringBuffer)charSequence).toString();
        int n3 = string7.indexOf("<head>");
        int n4 = string7.indexOf("</head>") + 7;
        string7 = string7.substring(0, n3) + string7.substring(n4, string7.length());
        n3 = string7.indexOf("<style>");
        n4 = string7.indexOf("</style>") + 8;
        string7 = string7.substring(0, n3) + string7.substring(n4, string7.length());
        n3 = string7.indexOf("<script>");
        n4 = string7.indexOf("</script>") + 9;
        string7 = string7.substring(0, n3) + string7.substring(n4, string7.length());
        n3 = string7.indexOf("<script>");
        n4 = string7.indexOf("</script>") + 9;
        string7 = string7.substring(0, n3) + string7.substring(n4, string7.length());
        string7 = string7.replace("<html>", "");
        string7 = string7.replace("</html>", "");
        string7 = string7.replace("<body>", "");
        string7 = string7.replace("</body>", "");
        fileWriter.append(string7);
        fileWriter.flush();
        fileWriter.close();
        this.listener.getLogger().println("Report Summary was created succesfully.");
    }

    public void retrievReportFromServer(boolean bl) throws Exception {
        if (this.summaryReportParams.summaryMode.equals("selfmade")) {
            return;
        }
        HttpURLConnection httpURLConnection = null;
        Utils utils = new Utils();
        String string = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/generate-summary-report";
        if (bl) {
            string = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/stream-summary-report";
        }
        int n = 20;
        String string2 = "20";
        String string3 = "c://temp";
        String string4 = "c://temp";
        if (!this.testMode) {
            n = this.vmgrRun.getRun().getNumber();
            string2 = this.vmgrRun.getRun().getId();
            string3 = this.vmgrRun.getJobWorkingDir();
            string4 = this.build.getRootDir().getAbsolutePath();
        }
        try {
            httpURLConnection = utils.getVAPIConnection(string, this.vAPIConnectionParam.authRequired, this.vAPIConnectionParam.vAPIUser, this.vAPIConnectionParam.vAPIPassword, "POST", this.vAPIConnectionParam.dynamicUserId, string2, n, string4, this.listener, this.vAPIConnectionParam.connTimeout, this.vAPIConnectionParam.readTimeout, this.vAPIConnectionParam.advConfig);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            String string5 = this.buildPostParamForSummaryReport(false);
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager is using the following POST data for getting the summary report:\n" + string5);
            } else {
                System.out.println(string5);
            }
            outputStream.write(string5.getBytes());
            outputStream.flush();
            if (this.checkResponseCode(httpURLConnection)) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                if (bl) {
                    String string6;
                    String string7 = string3 + File.separator + n + "." + string2 + ".summary.report";
                    FileWriter fileWriter = new FileWriter(string7);
                    while ((string6 = bufferedReader.readLine()) != null) {
                        fileWriter.append(string6);
                    }
                    fileWriter.flush();
                    fileWriter.close();
                    this.listener.getLogger().println("Report Summary was created succesfully.");
                } else {
                    String string8;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string8 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string8);
                    }
                    this.fetchFromRemoteURL(stringBuffer.toString());
                }
            } else {
                String string9;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                String string10 = string3 + File.separator + n + "." + string2 + ".summary.report";
                FileWriter fileWriter = new FileWriter(string10);
                fileWriter.append("<div class=\"microAgentWaiting\"><div class=\"spinnerMicroAgentMessage\"><p><img src=\"/plugin/vmanager-plugin/img/support-icon.png\"></img></p><p>");
                fileWriter.append("Failure to retrieve the report from the vManager server for this build.  Check your parameters.<br>Below you can find the exception that was thrown during the retrieval process:<br><br><strong>");
                while ((string9 = bufferedReader.readLine()) != null) {
                    fileWriter.append(string9 + "<br>");
                }
                if (httpURLConnection.getResponseCode() == 500 && "stream".equals(this.summaryReportParams.vManagerVersion)) {
                    fileWriter.append("<br><br>");
                    fileWriter.append("Hint: This error usually indicates that you choosed the wrong vManager version at the plugin configuration section for vManagerVersion.<br>");
                    fileWriter.append("If that's the case, and if your vManager server version is below 19.09 - set vManagerVersion as \"html\" (if pipeline dsl is used), or \"Lower than 19.09\" for regular post configuration mode.<br>");
                }
                fileWriter.append("</strong></p></div></div>");
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (Exception exception) {
            if (this.testMode) {
                exception.printStackTrace();
            } else {
                this.listener.getLogger().println("Failed to retrieve report from the vManager server.");
            }
            throw exception;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public void emailSummaryReport() throws Exception {
        if (!this.summaryReportParams.sendEmail) {
            return;
        }
        if (this.summaryReportParams.summaryMode.equals("selfmade")) {
            return;
        }
        HttpURLConnection httpURLConnection = null;
        Utils utils = new Utils();
        String string = this.vAPIConnectionParam.vAPIUrl + "/rest/reports/generate-summary-report";
        int n = 20;
        String string2 = "20";
        String string3 = "c://temp";
        String string4 = "c://temp";
        if (!this.testMode) {
            n = this.vmgrRun.getRun().getNumber();
            string2 = this.vmgrRun.getRun().getId();
            string3 = this.vmgrRun.getJobWorkingDir();
            string4 = this.build.getRootDir().getAbsolutePath();
        }
        try {
            httpURLConnection = utils.getVAPIConnection(string, this.vAPIConnectionParam.authRequired, this.vAPIConnectionParam.vAPIUser, this.vAPIConnectionParam.vAPIPassword, "POST", this.vAPIConnectionParam.dynamicUserId, string2, n, string4, this.listener, this.vAPIConnectionParam.connTimeout, this.vAPIConnectionParam.readTimeout, this.vAPIConnectionParam.advConfig);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            String string5 = this.buildPostParamForSummaryReport(true);
            if (!this.testMode) {
                this.listener.getLogger().println("ReportManager is using the following POST data for sending the summary report email:\n" + string5);
            } else {
                System.out.println(string5);
            }
            outputStream.write(string5.getBytes());
            outputStream.flush();
            if (!this.checkResponseCode(httpURLConnection)) {
                String string6;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string6 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string6);
                }
                this.listener.getLogger().println("Failed to send report using the vManager server.  Exception is:\n" + stringBuffer.toString());
            } else {
                this.listener.getLogger().println("Report Summary email was sent succesfully.");
            }
        }
        catch (Exception exception) {
            if (this.testMode) {
                exception.printStackTrace();
            } else {
                this.listener.getLogger().println("Failed to send report using the vManager server.");
            }
            throw exception;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public String getReportFromWorkspace() {
        String string = this.vmgrRun.getJobWorkingDir() + File.separator + this.vmgrRun.getRun().getNumber() + "." + this.vmgrRun.getRun().getId() + ".summary.report";
        String string2 = "<div class=\"microAgentWaiting\"><div class=\"spinnerMicroAgentMessage\"><p><img src=\"/plugin/vmanager-plugin/img/weblinks.png\"></img></p><p>Failed to find a report file for this build.<br>Please check that the following file exist:<br>" + string + "</p></div></div>";
        try {
            string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])));
        }
        catch (IOException iOException) {
            System.out.println("vManager Action - Can't find file for loading report: " + string);
            return string2;
        }
        return string2;
    }

    private boolean checkResponseCode(HttpURLConnection httpURLConnection) {
        try {
            if (httpURLConnection.getResponseCode() != 200 && httpURLConnection.getResponseCode() != 204 && httpURLConnection.getResponseCode() != 202 && httpURLConnection.getResponseCode() != 201 && httpURLConnection.getResponseCode() != 206 && httpURLConnection.getResponseCode() != 205 && httpURLConnection.getResponseCode() != 406) {
                if ("html".equals(this.summaryReportParams.vManagerVersion)) {
                    this.listener.getLogger().println("Error - Got wrong response from /reports/generate-summary-report - " + httpURLConnection.getResponseCode());
                } else {
                    this.listener.getLogger().println("Error - Got wrong response from /reports/stream-summary-report - " + httpURLConnection.getResponseCode());
                }
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public void fixUntrustCertificate() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }
}

