/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.Run;
import hudson.plugins.vmanager.BuildStatusMap;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRRun;

public class PostActionBase {
    public static final int numberOfBuilds = 15;
    public VMGRRun vmgrRun;

    public String getTimestampSortData(VMGRRun vMGRRun) {
        return String.valueOf(vMGRRun.getRun().getTimeInMillis());
    }

    public String getBuildOwner(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "owner", true);
    }

    public String getSessionTriage(VMGRRun vMGRRun) {
        String string = "#";
        String string2 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "id", false);
        if (string2.indexOf(",") > 0) {
            string = "../" + vMGRRun.getRun().getNumber() + "/vManagerSessionsView";
        } else {
            String string3 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "url", false);
            if ("NA".equals(string3)) {
                return "NA";
            }
            string = Utils.getRegressionURLFromVAPIURL(string3) + "?sessionid=" + string2;
        }
        return string;
    }

    public String getSessionStatus(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "status", false);
    }

    public String getSessionName(VMGRRun vMGRRun) {
        String string = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "name", false);
        if (!"NA".equals(string)) {
            String string2 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "session_code", false);
            string = string + " (" + string2 + ")";
        }
        return string;
    }

    public String getTotalRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "total_runs_in_session", false);
    }

    public String getPassedRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "passed_runs", false);
    }

    public String getFailedRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "failed_runs", false);
    }

    public String getOtherRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "other_runs", false);
    }

    public String getRunningRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "running", false);
    }

    public String getWaitingRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "waiting", false);
    }

    public String getTotalSessions(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "number_of_entities", false);
    }

    public String getTimestampString(VMGRRun vMGRRun) {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date(vMGRRun.getRun().getTimeInMillis()));
    }

    public String getBuildColumnSortData(Run<?, ?> run) {
        return String.valueOf(run.getNumber());
    }

    public String getSessionName(String string) {
        String string2 = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir() + "", "idNames", false);
        if (!string2.equals("NA")) {
            List<String> list = Arrays.asList(string2.split("\\s*,\\s*"));
            for (String string3 : list) {
                if (!string.equals(string3.substring(0, string3.indexOf("$@$")))) continue;
                return string3.substring(string3.indexOf("$@$") + 3, string3.length());
            }
        }
        return "NO_NAME";
    }

    public String getSessionLinkForBuild(String string) {
        String string2 = BuildStatusMap.getValue(this.vmgrRun.getRun().getId(), this.vmgrRun.getRun().getNumber(), this.vmgrRun.getJobWorkingDir() + "", "url", false);
        if ("NA".equals(string2)) {
            return "NA";
        }
        string2 = string2.replaceAll("/vapi", "");
        return string2 + "/regression/index.html?sessionid=" + string;
    }
}

