/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CloseUtil {
    private static final Logger LOG = Logger.getLogger(CloseUtil.class.getName());

    private CloseUtil() {
    }

    public static void close(Closeable closable, boolean ignore) throws IOException {
        if (closable == null) {
            return;
        }
        try {
            closable.close();
        }
        catch (IOException ex) {
            if (!ignore) {
                throw ex;
            }
            LOG.log(Level.INFO, "Ignoring exception closing " + closable, ex);
        }
    }

    public static void close(Closeable closable) {
        try {
            CloseUtil.close(closable, true);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "close() Should not happen!", ex);
        }
    }
}

