/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.jslint;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class JsLintParser
extends AbstractTypeParser {
    static final String TYPE_NAME = "jslint";

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag(TYPE_NAME);
        this.getParser().next();
        while (this.skipToTag("file")) {
            this.parseFileElement();
        }
    }

    private void parseFileElement() throws IOException, XmlPullParserException {
        String absoluteFileName = this.fixAbsolutePath(this.checkNotBlank("name"));
        this.getParser().next();
        FullFileModel fileModel = this.getFileModel(absoluteFileName);
        while (this.skipToTag("issue")) {
            fileModel.addViolation(this.parseIssueElement());
        }
        this.endElement();
    }

    private Violation parseIssueElement() throws IOException, XmlPullParserException {
        Violation violation = new Violation();
        violation.setType(TYPE_NAME);
        violation.setLine(this.getString("line"));
        violation.setMessage(this.getString("reason"));
        violation.setSource(this.getString("evidence"));
        violation.setSeverity("Medium");
        this.getParser().next();
        this.endElement();
        return violation;
    }
}

