/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.checkstyle;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.util.HashMapWithDefault;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class CheckstyleParser
extends AbstractTypeParser {
    private static final HashMapWithDefault<String, String> SEVERITIES = new HashMapWithDefault("Medium");

    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag("checkstyle");
        this.getParser().next();
        while (this.skipToTag("file")) {
            this.parseFileElement();
        }
    }

    private void parseFileElement() throws IOException, XmlPullParserException {
        String absoluteFileName = this.fixAbsolutePath(this.checkNotBlank("name"));
        this.getParser().next();
        FullFileModel fileModel = this.getFileModel(absoluteFileName);
        while (this.skipToTag("error")) {
            fileModel.addViolation(this.parseErrorElement());
        }
        this.endElement();
    }

    private Violation parseErrorElement() throws IOException, XmlPullParserException {
        Violation ret = new Violation();
        ret.setType("checkstyle");
        ret.setLine(this.getString("line"));
        ret.setMessage(this.getString("message"));
        ret.setSource(this.getString("source"));
        this.setSeverity(ret, this.getString("severity"));
        this.getParser().next();
        this.endElement();
        return ret;
    }

    private void setSeverity(Violation v, String severity) {
        v.setSeverity(SEVERITIES.get(severity));
        v.setSeverityLevel(Severity.getSeverityLevel(v.getSeverity()));
    }

    static {
        SEVERITIES.put("error", "High");
        SEVERITIES.put("warning", "Medium");
        SEVERITIES.put("info", "Low");
    }
}

