/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.model;

import hudson.plugins.violations.model.FileModel;
import hudson.plugins.violations.render.FileModelProxy;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildModel {
    private File xmlRoot;
    private Map<String, FileModelProxy> fileModelMap = new HashMap<String, FileModelProxy>();
    private SortedMap<String, SortedSet<FileCount>> typeMap = new TreeMap<String, SortedSet<FileCount>>();
    private SortedMap<String, TypeCount> typeCountMap;

    public BuildModel(File xmlFile) {
        this.xmlRoot = xmlFile.getParentFile();
    }

    public SortedMap<String, SortedSet<FileCount>> getTypeMap() {
        return this.typeMap;
    }

    public Map<String, FileModelProxy> getFileModelMap() {
        return this.fileModelMap;
    }

    public Collection<TypeCount> getTypeCounts() {
        if (this.typeCountMap == null) {
            this.typeCountMap = new TreeMap<String, TypeCount>();
            for (String t : this.typeMap.keySet()) {
                int count = 0;
                for (FileCount fc : (SortedSet)this.typeMap.get(t)) {
                    count += fc.getCount();
                }
                this.typeCountMap.put(t, new TypeCount(t, ((SortedSet)this.typeMap.get(t)).size(), count));
            }
        }
        return this.typeCountMap.values();
    }

    public Map<String, TypeCount> getTypeCountMap() {
        this.getTypeCounts();
        return this.typeCountMap;
    }

    public SortedSet<FileCount> getFileCounts(String type) {
        TreeSet ret = (TreeSet)this.typeMap.get(type);
        if (ret == null) {
            ret = new TreeSet();
            this.typeMap.put(type, ret);
        }
        return ret;
    }

    private FileModelProxy getFileNameProxy(String name) {
        FileModelProxy proxy = this.fileModelMap.get(name);
        if (proxy != null) {
            return proxy;
        }
        File xmlFile = new File(this.xmlRoot, "file/" + name + ".xml");
        this.fileModelMap.put(name, new FileModelProxy(xmlFile));
        return proxy;
    }

    public void addFileCount(String type, String name, int[] count) {
        FileModelProxy proxy = this.getFileNameProxy(name);
        this.getFileCounts(type).add(new FileCount(name, count, proxy));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileCount
    implements Comparable<FileCount> {
        private final String name;
        private final int totalCount;
        private final int[] counts;
        private final FileModelProxy proxy;

        public FileCount(String name, int[] counts, FileModelProxy proxy) {
            this.name = name;
            this.counts = counts;
            int t = 0;
            for (int i = 0; i < counts.length; ++i) {
                t += counts[i];
            }
            this.totalCount = t;
            this.proxy = proxy;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.totalCount;
        }

        public int getHigh() {
            return this.counts[0];
        }

        public int getMedium() {
            return this.counts[1] + this.counts[2] + this.counts[3];
        }

        public int getLow() {
            return this.counts[4];
        }

        public FileModel getFileModel() {
            return this.proxy.getFileModel();
        }

        @Override
        public int compareTo(FileCount other) {
            if (this == other) {
                return 0;
            }
            if (this.totalCount > other.totalCount) {
                return -1;
            }
            if (this.totalCount < other.totalCount) {
                return 1;
            }
            return this.name.compareTo(other.name);
        }
    }

    public static class TypeCount {
        private final String name;
        private final int count;
        private final int numberFiles;

        public TypeCount(String name, int numberFiles, int count) {
            this.name = name;
            this.numberFiles = numberFiles;
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public int getNumberFiles() {
            return this.numberFiles;
        }
    }
}

