/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.generate;

import hudson.FilePath;
import hudson.plugins.violations.ViolationsConfig;
import hudson.plugins.violations.generate.ExecuteFilePath;
import hudson.plugins.violations.generate.OutputBuildModel;
import hudson.plugins.violations.generate.OutputFileModel;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import java.io.IOException;

public class GenerateXML {
    private final FilePath targetDir;
    private final FullBuildModel model;
    private final ViolationsConfig config;

    public GenerateXML(FilePath targetDir, FullBuildModel model, ViolationsConfig config) {
        this.targetDir = targetDir;
        this.model = model;
        this.config = config;
    }

    public void execute() throws IOException, InterruptedException {
        new ExecuteFilePath(this.targetDir, "violations.xml", new OutputBuildModel(this.model)).execute();
        for (FullFileModel file : this.model.getFileModelMap().values()) {
            if (file.getTypeMap().size() == 0) continue;
            new ExecuteFilePath(this.targetDir, "file/" + file.getDisplayName() + ".xml", new OutputFileModel(file, this.config)).execute();
        }
    }
}

