/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.submitter;

import com.view26.ci.plugin.AutomationTestService;
import com.view26.ci.plugin.ConfigService;
import com.view26.ci.plugin.exception.StoreResultException;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.model.SubmittedResult;
import com.view26.ci.plugin.store.StoreResultService;
import com.view26.ci.plugin.store.StoreResultServiceImpl;
import com.view26.ci.plugin.submitter.JunitSubmitter;
import com.view26.ci.plugin.submitter.JunitSubmitterRequest;
import com.view26.ci.plugin.submitter.JunitSubmitterResult;
import com.view26.ci.plugin.utils.ResponseEntity;
import hudson.model.AbstractBuild;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JunitView26SubmitterImpl
implements JunitSubmitter {
    private static final Logger LOG = Logger.getLogger(JunitView26SubmitterImpl.class.getName());
    private StoreResultService storeResultService = new StoreResultServiceImpl();

    @Override
    public JunitSubmitterResult submit(JunitSubmitterRequest request) throws Exception {
        HashMap<String, String> tempHeaderMap = new HashMap<String, String>();
        ResponseEntity responseEntity = AutomationTestService.push(request.getUserName(), request.getProjectName(), request.getBuildNumber(), request.getBuildPath(), request.getTestResults(), request.getConfiguration(), tempHeaderMap);
        JunitSubmitterResult result = null;
        Boolean isSubmitSuccess = responseEntity != null && responseEntity.getStatusCode() == 200;
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
        result = new JunitSubmitterResult().setNumberOfTestResult(request.getTestResults().size()).setTestSuiteName(request.getProjectName() + "_" + timeStamp).setProjectName(request.getProjectName()).setSubmittedStatus(isSubmitSuccess != false ? "Completed" : "Failed");
        if (request.getTestResults().size() == 0) {
            result.setSubmittedStatus("Skipped");
        }
        return result;
    }

    @Override
    public SubmittedResult storeSubmittedResult(AbstractBuild build, JunitSubmitterResult result) throws StoreResultException {
        Configuration configuration = ConfigService.getPluginConfiguration(build.getProject());
        String view26Url = configuration == null ? "" : configuration.getUrl();
        Long projectId = configuration == null ? 0L : configuration.getProjectId();
        SubmittedResult submitResult = new SubmittedResult().setUrl(view26Url).setProjectName(result.getProjectName()).setBuildNumber(build.getNumber()).setStatusBuild(build.getResult().toString()).setTestSuiteName(result.getTestSuiteName()).setSubmitStatus(result.getSubmittedStatus()).setNumberTestResult(result.getNumberOfTestResult());
        try {
            this.storeResultService.store(build.getProject(), submitResult);
            return submitResult;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            throw new StoreResultException("Cannot store result." + e.getMessage(), e);
        }
    }
}

