/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.parse;

import com.view26.ci.plugin.model.AutomationTestResult;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.parse.CommonParsingUtils;
import com.view26.ci.plugin.parse.ParseRequest;
import com.view26.ci.plugin.parse.TestResultParser;
import com.view26.ci.plugin.utils.LoggerUtils;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.TestResult;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class PatternScanParser
implements TestResultParser {
    public List<AutomationTestResult> parse(ParseRequest request, String testResultLocation) throws Exception {
        JUnitParser jUnitParser = new JUnitParser(true);
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        AbstractBuild build = request.getBuild();
        Launcher launcher = request.getLauncher();
        BuildListener listener = request.getListener();
        testResults.add(jUnitParser.parseResult(testResultLocation, (Run)build, build.getWorkspace(), launcher, (TaskListener)listener));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(build.getStartTimeInMillis());
        return CommonParsingUtils.toAutomationTestResults(request.getConfiguration().getEachMethodAsTestCase(), testResults, gregorianCalendar.getTime(), build.getTime());
    }

    @Override
    public List<AutomationTestResult> parse(ParseRequest request) throws Exception {
        Configuration configuration = request.getConfiguration();
        BuildListener listener = request.getListener();
        LoggerUtils.formatInfo(listener.getLogger(), "Scan with test result location: %s", configuration.getResultPattern());
        return this.parse(request, configuration.getResultPattern());
    }
}

