/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.view26.ci.plugin.model.AutomationAttachment;
import com.view26.ci.plugin.model.AutomationTestLog;
import hudson.tasks.junit.CaseResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AutomationTestResult {
    private String name;
    private String status;
    private String priority = "Medium";
    private Float duration = Float.valueOf(0.0f);
    @JsonProperty(value="exe_start_date")
    private Date executedStartDate;
    @JsonProperty(value="exe_end_date")
    private Date executedEndDate;
    @JsonProperty(value="automation_content")
    private String automationContent;
    @JsonProperty(value="release_name")
    private String releaseName;
    @JsonProperty(value="ci_tool")
    private String ciTool = "jenkins";
    @JsonProperty(value="exec_type")
    private String executionType = "Functional";
    @JsonProperty(value="test_type")
    private String testType = "Automation";
    @JsonProperty(value="build_number")
    private String buildNumber;
    @JsonProperty(value="build_path")
    private String buildPath;
    @JsonProperty(value="test_set")
    private String testSet;
    @JsonProperty(value="assignee")
    private String assignee = "admin";
    @JsonProperty(value="test_step_logs")
    private List<AutomationTestLog> testLogs = new ArrayList<AutomationTestLog>();
    private List<AutomationAttachment> attachments;
    private int totalFailedTestSteps = 0;
    private int totalSkippedTestSteps = 0;
    private int totalSuccessTestSteps = 0;

    public String getTestSet() {
        return this.testSet;
    }

    public void setTestSet(String testSet) {
        this.testSet = testSet;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildPath() {
        return this.buildPath;
    }

    public void setBuildPath(String buildPath) {
        this.buildPath = buildPath;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public String getCiTool() {
        return this.ciTool;
    }

    public void setCiTool(String ciTool) {
        this.ciTool = ciTool;
    }

    public String getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(String executionType) {
        this.executionType = executionType;
    }

    public String getTestType() {
        return this.testType;
    }

    public void setTestType(String testType) {
        this.testType = testType;
    }

    public Date getExecutedStartDate() {
        return this.executedStartDate;
    }

    public void setExecutedStartDate(Date executedStartDate) {
        this.executedStartDate = executedStartDate;
    }

    public Date getExecutedEndDate() {
        return this.executedEndDate;
    }

    public void setExecutedEndDate(Date executedEndDate) {
        this.executedEndDate = executedEndDate;
    }

    public String getAutomationContent() {
        return this.automationContent;
    }

    public void setAutomationContent(String automationContent) {
        this.automationContent = automationContent;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<AutomationTestLog> getTestLogs() {
        return this.testLogs;
    }

    public void setTestLogs(List<AutomationTestLog> testLogs) {
        this.testLogs = testLogs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AutomationAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AutomationAttachment> attachments) {
        this.attachments = attachments;
    }

    public AutomationTestLog addTestLog(AutomationTestLog automationTestLog) {
        this.testLogs.add(automationTestLog);
        String status = automationTestLog.getStatus();
        if (CaseResult.Status.FAILED.toString().equalsIgnoreCase(status) || CaseResult.Status.REGRESSION.toString().equalsIgnoreCase(status)) {
            ++this.totalFailedTestSteps;
        }
        if (CaseResult.Status.SKIPPED.toString().equalsIgnoreCase(status)) {
            ++this.totalSkippedTestSteps;
        }
        if (CaseResult.Status.PASSED.toString().equalsIgnoreCase(status) || CaseResult.Status.FIXED.toString().equalsIgnoreCase(status)) {
            ++this.totalSuccessTestSteps;
        }
        this.setStatus(status);
        if (this.totalFailedTestSteps >= 1) {
            this.setStatus(CaseResult.Status.FAILED.toString());
        } else if (this.totalSuccessTestSteps >= 1) {
            this.setStatus(CaseResult.Status.PASSED.toString());
        } else if (this.totalSkippedTestSteps >= 1) {
            this.setStatus(CaseResult.Status.SKIPPED.toString());
        }
        return automationTestLog;
    }
}

