/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.action;

import com.view26.ci.plugin.ResourceBundle;
import com.view26.ci.plugin.model.SubmittedResult;
import com.view26.ci.plugin.store.ReadSubmitLogRequest;
import com.view26.ci.plugin.store.StoreResultService;
import com.view26.ci.plugin.store.StoreResultServiceImpl;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class StatisticsAction
extends Actionable
implements Action {
    private static final Logger LOG = Logger.getLogger(StatisticsAction.class.getName());
    private AbstractProject project;
    private final StoreResultService storeResultService = new StoreResultServiceImpl();

    public StatisticsAction(AbstractProject project) {
        this.project = project;
    }

    public final String getDisplayName() {
        return this.hasPermission() ? ResourceBundle.EXT_DISPLAY_NAME : null;
    }

    public final String getIconFileName() {
        return this.hasPermission() ? ResourceBundle.EXT_DISPLAY_ICON : null;
    }

    public String getUrlName() {
        return this.hasPermission() ? ResourceBundle.EXT_URL_NAME : null;
    }

    public String getSearchUrl() {
        return this.hasPermission() ? ResourceBundle.EXT_URL_SEARCH_NAME : null;
    }

    private boolean hasPermission() {
        return this.project.hasPermission(Item.READ);
    }

    public AbstractProject getProject() {
        return this.project;
    }

    @JavaScriptMethod
    public JSONObject getTreeResult(int page) {
        Map<Integer, SubmittedResult> results = null;
        try {
            AbstractProject project = this.getProject();
            results = this.storeResultService.fetchAll(new ReadSubmitLogRequest().setProject(project).setStart(0).setSize(-1)).getResults();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", null == results ? "" : results.values());
        return jsonObject;
    }
}

