/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.parse;

import com.view26.ci.plugin.model.AutomationTestResult;
import com.view26.ci.plugin.parse.CommonParsingUtils;
import com.view26.ci.plugin.parse.ParseRequest;
import com.view26.ci.plugin.parse.TestResultParser;
import com.view26.ci.plugin.utils.LoggerUtils;
import hudson.model.AbstractBuild;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class PublishResultParser
implements TestResultParser {
    @Override
    public List<AutomationTestResult> parse(ParseRequest request) throws Exception {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        AbstractBuild build = request.getBuild();
        TestResultAction resultAction = (TestResultAction)build.getAction(TestResultAction.class);
        if (resultAction != null) {
            testResults.add(resultAction.getResult());
        } else {
            AggregatedTestResultAction aggregatedTestResultAction = (AggregatedTestResultAction)build.getAction(AggregatedTestResultAction.class);
            if (aggregatedTestResultAction != null) {
                List childReports = aggregatedTestResultAction.getResult();
                if (childReports != null) {
                    for (AggregatedTestResultAction.ChildReport childReport : childReports) {
                        if (!(childReport.result instanceof TestResult)) continue;
                        testResults.add((TestResult)childReport.result);
                    }
                }
            } else {
                LoggerUtils.formatWarn(request.getListener().getLogger(), "No testResult action was added to project.", new Object[0]);
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(build.getStartTimeInMillis());
        return CommonParsingUtils.toAutomationTestResults(request.getConfiguration().getEachMethodAsTestCase(), testResults, gregorianCalendar.getTime(), build.getTime());
    }
}

