/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.store.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class BufferedAccessFile
extends RandomAccessFile {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final int bufferSize;
    private byte[] buffer;
    private int bufferEnd = 0;
    private int bufferPos = 0;
    private long realPos = 0L;

    public BufferedAccessFile(File file, String mode) throws IOException {
        this(file, mode, 256);
    }

    public BufferedAccessFile(File file, String mode, int bufferSize) throws IOException {
        super(file, mode);
        this.invalidate();
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
    }

    public BufferedAccessFile(String filename, String mode) throws IOException {
        this(filename, mode, 256);
    }

    public BufferedAccessFile(String filename, String mode, int bufsize) throws IOException {
        super(filename, mode);
        this.invalidate();
        this.bufferSize = bufsize;
        this.buffer = new byte[bufsize];
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.realPos - (long)this.bufferEnd + (long)this.bufferPos;
    }

    public final String getNextLine() throws IOException {
        return this.getNextLine(Charset.defaultCharset());
    }

    public final String getNextLine(Charset charset) throws IOException {
        String str = null;
        if (this.bufferEnd - this.bufferPos <= 0 && this.fillBuffer() < 0) {
            return null;
        }
        int lineEnd = -1;
        for (int i = this.bufferPos; i < this.bufferEnd; ++i) {
            if (this.buffer[i] != 10) continue;
            lineEnd = i;
            break;
        }
        if (lineEnd < 0) {
            int c;
            StringBuilder sb = new StringBuilder(256);
            while ((c = this.read()) != -1 && c != 10) {
                if ((char)c == '\r') continue;
                sb.append((char)c);
            }
            if (c == -1 && sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }
        str = lineEnd > 0 && this.buffer[lineEnd - 1] == 13 ? new String(this.buffer, this.bufferPos, lineEnd - this.bufferPos - 1, charset) : new String(this.buffer, this.bufferPos, lineEnd - this.bufferPos, charset);
        this.bufferPos = lineEnd + 1;
        return str;
    }

    @Override
    public final int read() throws IOException {
        if (this.bufferPos >= this.bufferEnd && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.bufferEnd == 0) {
            return -1;
        }
        return this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.bufferEnd - this.bufferPos;
        if (len <= leftover) {
            System.arraycopy(this.buffer, this.bufferPos, b, off, len);
            this.bufferPos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return len;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.realPos - pos);
        if (n >= 0 && n <= this.bufferEnd) {
            this.bufferPos = this.bufferEnd - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.bufferSize);
        if (n >= 0) {
            this.realPos += (long)n;
            this.bufferEnd = n;
            this.bufferPos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.bufferEnd = 0;
        this.bufferPos = 0;
        this.realPos = super.getFilePointer();
    }
}

