/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.view26.ci.plugin.utils.ClientRequestException;
import com.view26.ci.plugin.utils.HttpClientUtils;
import com.view26.ci.plugin.utils.JsonUtils;
import com.view26.ci.plugin.utils.ResponseEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OauthProvider {
    private static final Logger LOG = Logger.getLogger(OauthProvider.class.getName());
    public static String HEADER_KEY = "Basic amVua2luczpkZEtzVjA4NmNRbW8wWjZNUzBCaU4wekpidVdLbk5oNA==";

    private OauthProvider() {
    }

    public static String getAccessToken(String url, String apiKey) {
        return OauthProvider.getAccessToken(url, apiKey, HEADER_KEY);
    }

    public static String getAccessToken(String url, String apiKey, String secretKey) {
        StringBuilder sb = new StringBuilder().append(url).append("/oauth/token?grant_type=refresh_token").append("&refresh_token=").append(HttpClientUtils.encode(apiKey));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", secretKey);
        try {
            ResponseEntity entity = HttpClientUtils.post(sb.toString(), headers, null);
            if (200 != entity.getStatusCode()) {
                LOG.log(Level.WARNING, String.format("Cannot get access token from:%s, %s", url, entity.toString()));
                return null;
            }
            JsonNode node = JsonUtils.readTree(entity.getBody());
            if (null == node) {
                LOG.log(Level.WARNING, "Cannot extract access token from:" + entity.getBody());
                return null;
            }
            return JsonUtils.getText(node, "access_token");
        }
        catch (ClientRequestException e) {
            return null;
        }
    }

    public static Map<String, String> buildHeaders(String url, String apiKey, Map<String, String> headers) {
        String accessToken = OauthProvider.getAccessToken(url, apiKey);
        return OauthProvider.buildHeaders(accessToken, headers);
    }

    public static Map<String, String> buildHeaders(String accessToken, Map<String, String> headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", "Bearer " + accessToken);
        map.put("Content-Type", "application/json");
        if (null != headers && headers.size() > 0) {
            map.putAll(headers);
        }
        return map;
    }
}

