/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.parse;

import com.view26.ci.plugin.model.AutomationTestResult;
import com.view26.ci.plugin.parse.CommonParsingUtils;
import com.view26.ci.plugin.parse.ParseRequest;
import com.view26.ci.plugin.parse.PatternScanParser;
import com.view26.ci.plugin.utils.LoggerUtils;
import hudson.Util;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class AutoScanParser
extends PatternScanParser {
    private static final Logger LOG = Logger.getLogger(AutoScanParser.class.getName());
    public static final String SUREFIRE_REPORT = "surefire-reports";
    public static final String TEST_RESULT_LOCATIONS = "target/surefire-reports/*.xml";

    @Override
    public List<AutomationTestResult> parse(ParseRequest request) throws Exception {
        PrintStream logger = request.getListener().getLogger();
        LoggerUtils.formatInfo(logger, "Auto scan JUnit test results files.", new Object[0]);
        AbstractBuild build = request.getBuild();
        String basedDir = build.getWorkspace().toURI().getPath();
        List<String> resultFolders = CommonParsingUtils.scanJunitTestResultFolder(basedDir);
        LOG.info("Scanning junit test result in dir:" + basedDir + String.format(".Found: %s dirs, %s", resultFolders.size(), resultFolders));
        LinkedList<AutomationTestResult> result = new LinkedList<AutomationTestResult>();
        if (request.isMavenProject().booleanValue() && resultFolders.size() <= 1) {
            FileSet fs = Util.createFileSet((File)new File(basedDir), (String)TEST_RESULT_LOCATIONS);
            DirectoryScanner ds = fs.getDirectoryScanner();
            if (ds.getIncludedFiles().length > 0) {
                return this.parse(request, TEST_RESULT_LOCATIONS);
            }
        } else if (request.isMavenProject().booleanValue()) {
            for (String res : resultFolders) {
                if (!res.contains(SUREFIRE_REPORT)) continue;
                try {
                    result.addAll(this.parse(request, res + "/*.xml"));
                }
                catch (Exception e) {
                    LoggerUtils.formatWarn(logger, "Try to scan test result in: %s, error: %s", res, e.getMessage());
                }
            }
            return result;
        }
        for (String res : resultFolders) {
            try {
                result.addAll(this.parse(request, res + "/*.xml"));
            }
            catch (Exception e) {
                LoggerUtils.formatWarn(logger, "Try to scan test result in: %s, error: %s", res, e.getMessage());
            }
        }
        return result;
    }
}

