/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.viewcloner;

import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugin.viewcloner.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ViewHandler {
    private PrintStream logger;

    ViewHandler(TaskListener listener) {
        this.logger = listener.getLogger();
    }

    public Document getViewConfig(String url, String authStringEnc) {
        this.logger.println("[Get view config]");
        Document xml = Utils.getConfig(url, authStringEnc);
        this.logger.println("Successfuly acquired view config from " + url + "/config.xml");
        return xml;
    }

    public List<String> getNamesOfAssignedJobs(Document view) {
        this.logger.println("[Get assigned jobs]");
        List<String> jobNames = this.getAssignedJobs(view.getChildNodes(), new ArrayList<String>());
        this.logger.println("Jobs that are present in the view");
        for (String name : jobNames) {
            this.logger.println(name);
        }
        return jobNames;
    }

    private List<String> getAssignedJobs(NodeList nList, List<String> jobNames) {
        for (int i = 0; i < nList.getLength(); ++i) {
            if (Utils.isLowestNode(nList.item(i))) {
                if (nList.item(i).getNodeValue() == null || !nList.item(i).getParentNode().getParentNode().getNodeName().equals("jobNames")) continue;
                jobNames.add(nList.item(i).getNodeValue());
                continue;
            }
            this.getAssignedJobs(nList.item(i).getChildNodes(), jobNames);
        }
        return jobNames;
    }

    public void changeConfig(Document xml, Map<String, String> replacePatternOldNew) {
        Utils.changeConfig(xml, replacePatternOldNew);
    }

    public void createView(String url, String niewViewName, Document viewConfig, String authStringEnc) {
        this.logger.println("[Create view]");
        String config = Utils.docToString(viewConfig);
        Utils.createView(url, niewViewName, config, authStringEnc);
        this.logger.println("Creaeted view " + url + "/view/" + niewViewName);
    }
}

