/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.viewcloner;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Base64;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugin.viewcloner.JobHandler;
import org.jenkinsci.plugin.viewcloner.Utils;
import org.jenkinsci.plugin.viewcloner.ViewHandler;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Document;

public class ViewCloner
extends Builder
implements SimpleBuildStep {
    private String replacePatternString;
    private String url;
    private String niewViewName;
    private String password;
    private String username;

    @DataBoundConstructor
    public ViewCloner(String url, String replacePatternString, String niewViewName, String password, String username) {
        this.replacePatternString = replacePatternString;
        this.url = url;
        this.niewViewName = niewViewName;
        this.username = username;
        this.password = password;
    }

    public String getNiewViewName() {
        return this.niewViewName;
    }

    public String getReplacePatternString() {
        return this.replacePatternString;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Base64.encode((byte[])this.password.getBytes(Charset.forName("UTF-8")));
    }

    public String getUrl() {
        return this.url;
    }

    public void perform(Run<?, ?> run, FilePath path, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.url = Utils.removeEndSlash(this.url);
        String urlToParentView = Utils.getUrlToTheParentView(this.url);
        String authString = this.username + ":" + this.password;
        String authStringEnc = Base64.encode((byte[])authString.getBytes("UTF-8"));
        ViewHandler viewHandler = new ViewHandler(listener);
        JobHandler jobHandler = new JobHandler(listener);
        Map<String, String> replacePatternOldNew = Utils.processReplacePatern(this.replacePatternString);
        Document viewConfig = viewHandler.getViewConfig(this.url, authStringEnc);
        List<String> jobNames = viewHandler.getNamesOfAssignedJobs(viewConfig);
        Map<String, Document> jobNameConfig = jobHandler.getJobConfigs(jobNames, authStringEnc);
        Map<String, Document> newJobNameConfig = jobHandler.changeNamesAndConfigs(jobNameConfig, replacePatternOldNew);
        viewHandler.changeConfig(viewConfig, replacePatternOldNew);
        jobHandler.createJobs(newJobNameConfig);
        viewHandler.createView(urlToParentView, this.niewViewName, viewConfig, authStringEnc);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "View clone";
        }
    }
}

