/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.viewcloner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utils {
    static final String CONFIG_XML_PATH = "/config.xml";

    static Document getConfig(String objectPath, String authStringEnc) {
        String configPath = objectPath + CONFIG_XML_PATH;
        URL url = null;
        HttpURLConnection conn = null;
        try {
            url = new URL(configPath);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
            Document xml = Utils.streamToDoc(conn.getInputStream());
            int response = conn.getResponseCode();
            if (response != 200) {
                throw new RuntimeException("Unable to access " + configPath + "\nResponce code: " + response);
            }
            return xml;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to access " + configPath, e);
        }
    }

    static void createView(String parentViewPath, String niewViewName, String viewConfig, String authStringEnc) {
        try {
            String url = parentViewPath + "/createView?name=" + niewViewName;
            URL obj = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + authStringEnc);
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(viewConfig);
            wr.flush();
            wr.close();
            int response = conn.getResponseCode();
            if (response != 200) {
                throw new RuntimeException("Unable to create a view \nResponce code: " + response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a view" + e);
        }
    }

    static Document streamToDoc(InputStream inputStream) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return doc;
    }

    static InputStream docToStream(Document doc) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static void changeConfig(Document xml, Map<String, String> replacePatternOldNew) {
        Utils.changeConfig(xml.getChildNodes(), replacePatternOldNew);
    }

    private static void changeConfig(NodeList nList, Map<String, String> replacePatternOldNew) {
        for (int i = 0; i < nList.getLength(); ++i) {
            if (Utils.isLowestNode(nList.item(i))) {
                if (nList.item(i).getNodeValue() == null || nList.item(i).getNodeValue().trim().equals("")) continue;
                String newValue = Utils.paramChange(nList.item(i).getNodeValue(), replacePatternOldNew);
                nList.item(i).setNodeValue(newValue);
                continue;
            }
            Utils.changeConfig(nList.item(i).getChildNodes(), replacePatternOldNew);
        }
    }

    static boolean isLowestNode(Node node) {
        return !node.hasChildNodes();
    }

    static String paramChange(String value, Map<String, String> paramReplacementMap) {
        for (Map.Entry<String, String> pair : paramReplacementMap.entrySet()) {
            if ((value = value.replace(pair.getKey(), pair.getValue())).contains("\r\n")) continue;
            value = value.replace("\n", "\r\n");
        }
        return value;
    }

    static Map<String, String> processReplacePatern(String replacePatern) {
        String[] oldNewPair;
        HashMap<String, String> paramReplacementMap = new HashMap<String, String>();
        for (String pair : oldNewPair = replacePatern.split(",")) {
            String[] values = pair.trim().split("=");
            paramReplacementMap.put(values[0], values[1]);
        }
        return paramReplacementMap;
    }

    static String docToString(Document doc) {
        try {
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting to String", e);
        }
    }

    static String removeEndSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    static String getUrlToTheParentView(String url) {
        Pattern pattern = Pattern.compile("(.*)/view/(.*)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            url = matcher.group(1);
            return url;
        }
        throw new RuntimeException("Unable to copy view: No views in the provided url " + url);
    }
}

