/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.viewcloner;

import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactoryConfigurationError;
import jenkins.model.Jenkins;
import org.jenkinsci.plugin.viewcloner.Utils;
import org.w3c.dom.Document;

public class JobHandler {
    private Jenkins jenkins = Jenkins.getInstance();
    private PrintStream logger;

    JobHandler(TaskListener listener) {
        this.logger = listener.getLogger();
    }

    public Map<String, Document> getJobConfigs(List<String> jobNames, String authStringEnc) {
        HashMap<String, Document> map = new HashMap<String, Document>();
        this.logger.println("[Get job configs]");
        for (String jobName : jobNames) {
            if (this.jenkins.getItem(jobName) == null) continue;
            String url = this.jenkins.getRootUrl() + "job/" + jobName;
            Document xml = Utils.getConfig(url, authStringEnc);
            this.logger.println("Successfuly acquired job config from " + url + "/config.xml");
            map.put(jobName, xml);
        }
        return map;
    }

    public Map<String, Document> changeNamesAndConfigs(Map<String, Document> jobNameConfig, Map<String, String> replacePatternOldNew) {
        HashMap<String, Document> newJobNameConfig = new HashMap<String, Document>();
        for (Map.Entry<String, Document> pair : jobNameConfig.entrySet()) {
            Utils.changeConfig(pair.getValue(), replacePatternOldNew);
            String newName = Utils.paramChange(pair.getKey(), replacePatternOldNew);
            newJobNameConfig.put(newName, pair.getValue());
        }
        return newJobNameConfig;
    }

    public void createJobs(Map<String, Document> jobNameConfig) {
        Iterator<Map.Entry<String, Document>> it = jobNameConfig.entrySet().iterator();
        this.logger.println("[Create jobs]");
        while (it.hasNext()) {
            Map.Entry<String, Document> pair = it.next();
            if (this.jenkins.getItem(pair.getKey()) == null) {
                try {
                    this.jenkins.createProjectFromXML(pair.getKey(), Utils.docToStream(pair.getValue()));
                    this.logger.println("Job " + pair.getKey() + " created");
                    continue;
                }
                catch (IOException | TransformerFactoryConfigurationError e) {
                    throw new RuntimeException(e);
                }
            }
            this.logger.println("Job with name " + pair.getKey() + " already exists");
        }
    }
}

