/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VaultSCMChangeLogSet
extends ChangeLogSet<VaultSCMChangeLogSetEntry> {
    private Collection<VaultSCMChangeLogSetEntry> changes = new ArrayList<VaultSCMChangeLogSetEntry>();

    protected VaultSCMChangeLogSet(AbstractBuild<?, ?> build) {
        super(build);
    }

    public Iterator<VaultSCMChangeLogSetEntry> iterator() {
        return this.changes.iterator();
    }

    public boolean isEmptySet() {
        return this.changes.isEmpty();
    }

    public boolean addEntry(VaultSCMChangeLogSetEntry e) {
        return this.changes.add(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VaultSCMChangeLogSetEntry
    extends ChangeLogSet.Entry {
        private String comment;
        String affectedFile;
        String version;
        String date;
        private User user;
        private String action;

        public VaultSCMChangeLogSetEntry(String comment, String version, String date, ChangeLogSet parent, String userName) {
            this.affectedFile = "User defined path";
            this.comment = comment;
            this.version = version;
            this.date = date;
            this.user = User.get((String)userName);
            this.setParent(parent);
        }

        public VaultSCMChangeLogSetEntry() {
        }

        public String getMsg() {
            return "Changed: ".concat(" Version: ").concat(this.version).concat(" Comment: ").concat(this.comment);
        }

        public String getVersion() {
            return this.version;
        }

        public String getComment() {
            return this.comment;
        }

        public Collection<String> getAffectedPaths() {
            ArrayList<String> col = new ArrayList<String>();
            col.add("user defined path");
            return col;
        }

        public User getAuthor() {
            if (this.user == null) {
                return User.getUnknown();
            }
            return this.user;
        }

        @Exported
        public EditType getEditType() {
            if (this.action.equalsIgnoreCase("delete")) {
                return EditType.DELETE;
            }
            if (this.action.equalsIgnoreCase("add")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }

        @Exported
        String getPath() {
            return this.affectedFile;
        }
    }
}

