/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.VaultSCMChangeLogParser;
import org.jvnet.hudson.plugins.VaultSCMInstallation;
import org.jvnet.hudson.plugins.VaultSCMRevisionState;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaultSCM
extends SCM {
    private static final Logger LOG = Logger.getLogger(VaultSCM.class.getName());
    private String serverName;
    private String userName;
    private Secret password;
    private String repositoryName;
    private String vaultName;
    private String path;
    private Boolean sslEnabled;
    private Boolean useNonWorkingFolder;
    private String merge;
    private String fileTime;
    private Boolean makeWritableEnabled;
    private Boolean verboseEnabled;
    @Extension
    public static final VaultSCMDescriptor DESCRIPTOR = new VaultSCMDescriptor();
    public static final SimpleDateFormat VAULT_DATETIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Boolean getMakeWritableEnabled() {
        return this.makeWritableEnabled;
    }

    public void setMakeWritableEnabled(Boolean makeWritableEnabled) {
        this.makeWritableEnabled = makeWritableEnabled;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Boolean getVersboseEnabled() {
        return this.verboseEnabled;
    }

    public void setverboseEnabled(Boolean verboseEnabled) {
        this.verboseEnabled = verboseEnabled;
    }

    public Boolean getUseNonWorkingFolder() {
        return this.useNonWorkingFolder;
    }

    public void setNonWorkingFolder(Boolean useNonWorkingFolder) {
        this.useNonWorkingFolder = useNonWorkingFolder;
    }

    public String getMerge() {
        return this.merge;
    }

    public void setMerge(String merge) {
        this.merge = merge;
    }

    public String getFileTime() {
        return this.fileTime;
    }

    public void setFileTime(String fileTime) {
        this.fileTime = fileTime;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    public void setPassword(String password) {
        this.password = Secret.fromString((String)password);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public VaultSCMInstallation getVault() {
        for (VaultSCMInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.vaultName == null || !i.getName().equals(this.vaultName)) continue;
            return i;
        }
        return null;
    }

    @DataBoundConstructor
    public VaultSCM(String serverName, String path, String userName, String password, String repositoryName, String vaultName, Boolean sslEnabled, Boolean useNonWorkingFolder, String merge, String fileTime, Boolean makeWritableEnabled, Boolean verboseEnabled) {
        this.serverName = serverName;
        this.userName = userName;
        this.password = Secret.fromString((String)password);
        this.repositoryName = repositoryName;
        this.vaultName = vaultName;
        this.path = path;
        this.sslEnabled = sslEnabled;
        this.useNonWorkingFolder = useNonWorkingFolder;
        this.merge = merge.isEmpty() || merge == null ? "overwrite" : merge;
        this.fileTime = fileTime.isEmpty() || fileTime == null ? "modification" : fileTime;
        this.makeWritableEnabled = makeWritableEnabled;
        this.verboseEnabled = verboseEnabled;
    }

    public SCMDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        VaultSCMRevisionState scmRevisionState = new VaultSCMRevisionState();
        Date lastBuildDate = build.getTime();
        scmRevisionState.setDate(lastBuildDate);
        return scmRevisionState;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        Date lastBuild = ((VaultSCMRevisionState)baseline).getDate();
        LOG.log(Level.INFO, "Last Build Date set to {0}", lastBuild.toString());
        Date now = new Date();
        File temporaryFile = File.createTempFile("changes", ".txt");
        int countChanges = this.determineChangeCount(launcher, workspace, listener, lastBuild, now, temporaryFile);
        temporaryFile.delete();
        if (countChanges == 0) {
            return PollingResult.NO_CHANGES;
        }
        return PollingResult.BUILD_NOW;
    }

    private boolean checkVaultPath(String path, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        FilePath exec = new FilePath(launcher.getChannel(), path);
        try {
            if (!exec.exists()) {
                return false;
            }
        }
        catch (IOException e) {
            listener.fatalError("Failed checking for existence of " + path);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getVaultPath(Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String defaultPath = "C:\\Program Files\\SourceGear\\Vault Client\\vault.exe";
        String defaultPathX86 = "C:\\Program Files (x86)\\SourceGear\\Vault Client\\vault.exe";
        VaultSCMInstallation installation = this.getVault();
        if (installation == null) {
            if (this.checkVaultPath("C:\\Program Files\\SourceGear\\Vault Client\\vault.exe", launcher, listener)) {
                return "C:\\Program Files\\SourceGear\\Vault Client\\vault.exe";
            }
            if (this.checkVaultPath("C:\\Program Files (x86)\\SourceGear\\Vault Client\\vault.exe", launcher, listener)) {
                return "C:\\Program Files (x86)\\SourceGear\\Vault Client\\vault.exe";
            }
            listener.fatalError("Failed find vault client");
            return null;
        }
        String pathToVault = (installation = installation.forNode(Computer.currentComputer().getNode(), listener)).getVaultLocation();
        if (this.checkVaultPath(pathToVault, launcher, listener)) return pathToVault;
        listener.fatalError(pathToVault + " doesn't exist");
        return null;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        boolean returnValue;
        String pathToVault = this.getVaultPath(launcher, (TaskListener)listener);
        if (pathToVault == null) {
            return false;
        }
        if (this.serverName != null) {
            listener.getLogger().println("server: " + this.serverName);
        }
        ArgumentListBuilder argBuildr = new ArgumentListBuilder();
        argBuildr.add(pathToVault);
        argBuildr.add("GET");
        if (!this.serverName.isEmpty()) {
            argBuildr.add(new String[]{"-host", this.serverName});
        }
        if (!this.userName.isEmpty()) {
            argBuildr.add(new String[]{"-user", this.userName});
        }
        if (!Secret.toString((Secret)this.password).isEmpty()) {
            argBuildr.add("-password");
            argBuildr.add(Secret.toString((Secret)this.password), true);
        }
        if (!this.repositoryName.isEmpty()) {
            argBuildr.add(new String[]{"-repository", this.repositoryName});
        }
        if (this.sslEnabled.booleanValue()) {
            argBuildr.add("-ssl");
        }
        if (this.verboseEnabled.booleanValue()) {
            argBuildr.add("-verbose");
        }
        if (this.makeWritableEnabled.booleanValue()) {
            argBuildr.add("-makewritable");
        }
        argBuildr.add(new String[]{"-merge", this.merge});
        argBuildr.add(new String[]{"-setfiletime", this.fileTime});
        if (this.useNonWorkingFolder.booleanValue()) {
            argBuildr.add(new String[]{"-nonworkingfolder", workspace.getRemote()});
        } else {
            argBuildr.add(new String[]{"-workingfolder", workspace.getRemote()});
        }
        argBuildr.add(this.path);
        int cmdResult = launcher.launch().cmds(argBuildr).envs((Map)build.getEnvironment(TaskListener.NULL)).stdout((OutputStream)listener.getLogger()).pwd(workspace).join();
        if (cmdResult == 0) {
            Date lastBuildDate;
            Run lastBuild = build.getPreviousBuild();
            if (lastBuild == null) {
                lastBuildDate = new Date();
                lastBuildDate.setTime(0L);
                listener.getLogger().print("Never been built.");
            } else {
                lastBuildDate = lastBuild.getTimestamp().getTime();
            }
            Date now = new Date();
            returnValue = this.captureChangeLog(launcher, workspace, listener, lastBuildDate, now, changelogFile);
        } else {
            returnValue = false;
        }
        listener.getLogger().println("Checkout completed.");
        return returnValue;
    }

    public ChangeLogParser createChangeLogParser() {
        return new VaultSCMChangeLogParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean captureChangeLog(Launcher launcher, FilePath workspace, BuildListener listener, Date lastBuildDate, Date currentDate, File changelogFile) throws IOException, InterruptedException {
        boolean result = true;
        String latestBuildDate = VAULT_DATETIME_FORMATTER.format(lastBuildDate);
        String today = VAULT_DATETIME_FORMATTER.format(currentDate);
        String pathToVault = this.getVaultPath(launcher, (TaskListener)listener);
        if (pathToVault == null) {
            return false;
        }
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintWriter writer = new PrintWriter(new FileWriter(changelogFile));
            try {
                ArgumentListBuilder argBuildr = new ArgumentListBuilder();
                argBuildr.add(pathToVault);
                argBuildr.add("VERSIONHISTORY");
                if (!this.serverName.isEmpty()) {
                    argBuildr.add(new String[]{"-host", this.serverName});
                }
                if (!this.userName.isEmpty()) {
                    argBuildr.add(new String[]{"-user", this.userName});
                }
                if (!Secret.toString((Secret)this.password).isEmpty()) {
                    argBuildr.add("-password");
                    argBuildr.add(Secret.toString((Secret)this.password), true);
                }
                if (!this.repositoryName.isEmpty()) {
                    argBuildr.add(new String[]{"-repository", this.repositoryName});
                }
                if (this.sslEnabled.booleanValue()) {
                    argBuildr.add("-ssl");
                }
                argBuildr.add(new String[]{"-enddate", today});
                argBuildr.add(new String[]{"-begindate", latestBuildDate});
                argBuildr.add(this.path);
                int cmdResult = launcher.launch().cmds(argBuildr).envs(new String[0]).stdout((OutputStream)bos).pwd(workspace).join();
                if (cmdResult != 0) {
                    listener.fatalError("Changelog failed with exit code " + cmdResult);
                    result = false;
                }
            }
            finally {
                writer.close();
                bos.close();
            }
        }
        finally {
            os.close();
        }
        listener.getLogger().println("Changelog calculated successfully.");
        listener.getLogger().println("Change log file: " + changelogFile.getAbsolutePath());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int determineChangeCount(Launcher launcher, FilePath workspace, TaskListener listener, Date lastBuildDate, Date currentDate, File changelogFile) throws IOException, InterruptedException {
        int result = 0;
        String latestBuildDate = VAULT_DATETIME_FORMATTER.format(lastBuildDate);
        String today = VAULT_DATETIME_FORMATTER.format(currentDate);
        String pathToVault = this.getVaultPath(launcher, listener);
        if (pathToVault == null) {
            return 0;
        }
        FileOutputStream os = new FileOutputStream(changelogFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintWriter writer = new PrintWriter(new FileWriter(changelogFile));
            try {
                ArgumentListBuilder argBuildr = new ArgumentListBuilder();
                argBuildr.add(pathToVault);
                argBuildr.add("VERSIONHISTORY");
                if (!this.serverName.isEmpty()) {
                    argBuildr.add(new String[]{"-host", this.serverName});
                }
                if (!this.userName.isEmpty()) {
                    argBuildr.add(new String[]{"-user", this.userName});
                }
                if (!Secret.toString((Secret)this.password).isEmpty()) {
                    argBuildr.add("-password");
                    argBuildr.add(Secret.toString((Secret)this.password), true);
                }
                if (!this.repositoryName.isEmpty()) {
                    argBuildr.add(new String[]{"-repository", this.repositoryName});
                }
                if (this.sslEnabled.booleanValue()) {
                    argBuildr.add("-ssl");
                }
                argBuildr.add(new String[]{"-enddate", today});
                argBuildr.add(new String[]{"-begindate", latestBuildDate});
                argBuildr.add(this.path);
                int cmdResult = launcher.launch().cmds(argBuildr).envs(new String[0]).stdout((OutputStream)bos).pwd(workspace).join();
                if (cmdResult != 0) {
                    listener.fatalError("Determine changes count failed with exit code " + cmdResult);
                    result = 0;
                }
            }
            finally {
                writer.close();
                bos.close();
            }
        }
        finally {
            os.close();
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(changelogFile);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("item");
            result = nodeLst.getLength();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VaultSCMDescriptor
    extends SCMDescriptor<VaultSCM> {
        private volatile VaultSCMInstallation[] installations = new VaultSCMInstallation[0];
        private static final List<String> MERGE_OPTIONS = Arrays.asList("automatic", "overwrite", "later");
        private static final List<String> FILETIME_OPTIONS = Arrays.asList("checkin", "current", "modification");

        protected VaultSCMDescriptor() {
            super(VaultSCM.class, null);
            this.load();
        }

        public VaultSCMInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(VaultSCMInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }

        public VaultSCMInstallation.DescriptorImpl getToolDescriptor() {
            return (VaultSCMInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(VaultSCMInstallation.DescriptorImpl.class));
        }

        public String getDisplayName() {
            return "SourceGear Vault";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            VaultSCM scm = (VaultSCM)((Object)req.bindJSON(VaultSCM.class, formData));
            return scm;
        }

        public List<String> getMergeOptions() {
            return MERGE_OPTIONS;
        }

        public List<String> getFileTimeOptions() {
            return FILETIME_OPTIONS;
        }

        public FormValidation doCheckServerName(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckVaultExecutable(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckRepositoryName(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckPath(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateRequired((String)value);
        }
    }
}

