/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.variant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class VariantSet {
    static VariantSet INSTANCE = VariantSet.makeDefault();
    private final Set<String> activeVariants = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(VariantSet.class.getName());

    VariantSet(String ... values) {
        this.activeVariants.addAll(Arrays.asList(values));
    }

    public static VariantSet getInstance() {
        return INSTANCE;
    }

    static VariantSet makeDefault() {
        VariantSet v = new VariantSet(new String[0]);
        v.activeVariants.addAll(v.parseVariants());
        return v;
    }

    public boolean contains(String name) {
        return this.activeVariants.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> parseVariants() {
        HashSet<String> values = new HashSet<String>();
        this.addVariants(values, System.getenv("JENKINS_VARIANT"));
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            InputStream in = j.servletContext.getResourceAsStream("META-INF/MANIFEST.MF");
            try {
                if (in != null) {
                    Manifest m = new Manifest(in);
                    this.addVariants(values, m.getMainAttributes().getValue("Jenkins-Variant"));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to parse Jenkins-Variants from manifest", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            File[] children = new File(j.getRootDir(), "variants").listFiles();
            if (children != null) {
                for (File ch : children) {
                    values.add(ch.getName());
                }
            }
        }
        return values;
    }

    private void addVariants(Set<String> values, String e) {
        if (e != null) {
            for (String t : e.split(" +")) {
                if ((t = t.trim()).length() <= 0) continue;
                values.add(t);
            }
        }
    }
}

