/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.util;

import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import hudson.model.Run;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.filters.StringInputStream;

public class ValgrindSourceFile {
    public static final String SOURCE_DIRECTORY = "valgrind-plugin/source-files";
    private static final int GENERATED_HTML_SOURCE_HEADER_SIZE = 12;
    private static final int GENERATED_HTML_SOURCE_FOOTER_SIZE = 9;
    private static final String ERROR_LINE_COLOR = "#FCAF3E";
    private static final String SOURCE_NOT_AVAIABLE_MESSAGE = "<b>Source code not available</b>";
    private Map<String, List<String>> sourceCodeBuffer = new HashMap<String, List<String>>();
    private Map<String, String> sourceFileLookup;
    private int linesBefore;
    private int linesAfter;
    private Run<?, ?> build;

    public ValgrindSourceFile(int linesBefore, int linesAfter, Map<String, String> sourceFileLookup, Run<?, ?> build) {
        this.sourceFileLookup = sourceFileLookup;
        this.linesAfter = linesAfter;
        this.linesBefore = linesBefore;
        this.build = build;
    }

    public String getSnippet(String fileName, Integer lineNumber) {
        List<String> lines;
        if (fileName == null || lineNumber == null) {
            return SOURCE_NOT_AVAIABLE_MESSAGE;
        }
        if (!this.sourceFileLookup.containsKey(fileName) || this.sourceFileLookup.get(fileName) == null) {
            return SOURCE_NOT_AVAIABLE_MESSAGE;
        }
        String localFileName = this.sourceFileLookup.get(fileName);
        if (!this.sourceCodeBuffer.containsKey(localFileName)) {
            this.load(localFileName);
        }
        if ((lines = this.sourceCodeBuffer.get(localFileName)) == null || lines.isEmpty()) {
            return SOURCE_NOT_AVAIABLE_MESSAGE;
        }
        StringBuilder output = new StringBuilder();
        ListIterator<String> it = lines.listIterator();
        int currentLine = 0;
        int errorLine = lineNumber + 12;
        while (it.hasNext()) {
            String line = it.next();
            boolean append = false;
            if (++currentLine <= 12) {
                append = true;
            }
            if (currentLine >= errorLine - this.linesBefore && currentLine <= errorLine + this.linesAfter) {
                append = true;
            }
            if (currentLine > lines.size() - 9) {
                append = true;
            }
            if (currentLine == errorLine) {
                output.append("</code></td></tr>\n");
                output.append("<tr><td bgcolor=\"#FCAF3E\">\n");
                output.append("<code>\n");
                output.append(line + "\n");
                output.append("</code></td></tr>\n");
                output.append("<tr><td>\n");
                output.append("<code>\n");
                continue;
            }
            if (!append) continue;
            output.append(line + "\n");
        }
        return output.toString();
    }

    private void load(String filePath) {
        this.sourceCodeBuffer.put(filePath, null);
        try {
            File dir = new File(this.build.getRootDir(), SOURCE_DIRECTORY);
            File file = new File(dir, filePath);
            if (file.exists() && file.isFile()) {
                String sourceCode = this.highlightSource(IOUtils.toString((InputStream)new FileInputStream(file)));
                List lines = IOUtils.readLines((InputStream)new StringInputStream(sourceCode));
                this.sourceCodeBuffer.put(filePath, lines);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String highlightSource(String src) throws IOException {
        JavaSource source = new JavaSourceParser().parse(src);
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
        StringWriter writer = new StringWriter();
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setShowLineNumbers(true);
        options.setAddLineAnchors(true);
        converter.convert(source, options, (Writer)writer);
        return writer.toString();
    }
}

