/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.util;

import hudson.EnvVars;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.valgrind.config.ValgrindPublisherConfig;
import org.jenkinsci.plugins.valgrind.model.ValgrindReport;
import org.jenkinsci.plugins.valgrind.util.ValgrindLogger;

public class ValgrindEvaluator {
    private ValgrindPublisherConfig config;
    private TaskListener listener;

    public ValgrindEvaluator(ValgrindPublisherConfig config, TaskListener listener) {
        this.config = config;
        this.listener = listener;
    }

    public void evaluate(ValgrindReport report, Run<?, ?> build, EnvVars env) {
        build.setResult(this.evaluate(report.getErrorList().getLeakDefinitelyLostErrorCount(), env.expand(this.config.getUnstableThresholdDefinitelyLost()), env.expand(this.config.getFailThresholdDefinitelyLost())));
        build.setResult(this.evaluate(report.getErrorList().getInvalidReadErrorCount() + report.getErrorList().getInvalidWriteErrorCount(), env.expand(this.config.getUnstableThresholdInvalidReadWrite()), env.expand(this.config.getFailThresholdInvalidReadWrite())));
        build.setResult(this.evaluate(report.getErrorList().getErrorCount(), env.expand(this.config.getUnstableThresholdTotal()), env.expand(this.config.getFailThresholdTotal())));
        if (report.hasParserErrors() && this.config.isFailBuildOnInvalidReports()) {
            build.setResult(Result.FAILURE);
        }
    }

    private boolean exceedsThreshold(int errorCount, String threshold) {
        if (threshold == null || threshold.isEmpty()) {
            return false;
        }
        try {
            Integer i = Integer.valueOf(threshold);
            return errorCount > i;
        }
        catch (NumberFormatException e) {
            ValgrindLogger.log(this.listener, "ERROR: '" + threshold + "' is not a valid threshold");
            return false;
        }
    }

    private Result evaluate(int errorCount, String unstableThreshold, String failThreshold) {
        if (this.exceedsThreshold(errorCount, failThreshold)) {
            return Result.FAILURE;
        }
        if (this.exceedsThreshold(errorCount, unstableThreshold)) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }
}

