/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.parser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jenkinsci.plugins.valgrind.model.ValgrindAuxiliary;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindErrorKind;
import org.jenkinsci.plugins.valgrind.model.ValgrindProcess;
import org.jenkinsci.plugins.valgrind.model.ValgrindReport;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktrace;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktraceFrame;
import org.jenkinsci.plugins.valgrind.model.ValgrindThread;
import org.jenkinsci.plugins.valgrind.util.ValgrindLogger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindSaxParser
implements Serializable {
    private static final long serialVersionUID = -6889121223670989851L;

    public ValgrindReport parse(File file) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        Handler handler = new Handler();
        try {
            saxParser.parse(file, (DefaultHandler)handler);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
        return handler.getReport();
    }

    private static class Handler
    extends DefaultHandler {
        private ValgrindReport currentReport;
        private ValgrindProcess currentProcess;
        private ValgrindThread currentThread;
        private ValgrindError currentError;
        private ValgrindStacktrace currentStacktrace;
        private ValgrindStacktraceFrame currentStacktraceFrame;
        private ValgrindAuxiliary currentAuxiliary;
        private StringBuilder data;
        private String path = "";
        private String currentText = "";

        private Handler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.path = this.path + "/" + qName;
            if (this.path.equalsIgnoreCase("/valgrindoutput")) {
                this.currentReport = new ValgrindReport();
                this.currentProcess = new ValgrindProcess();
                this.currentReport.addProcess(this.currentProcess);
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread")) {
                this.currentThread = new ValgrindThread();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread/hthreadid")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread/isrootthread") && this.currentThread != null) {
                this.currentThread.setRootThread(true);
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack")) {
                this.currentStacktrace = new ValgrindStacktrace();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error")) {
                this.currentError = new ValgrindError();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/unique")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/pid")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/ppid")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/kind")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/what")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/argv/exe")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/vargv/arg")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/argv/arg")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/text")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/leakedbytes")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/leakedblocks")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/auxwhat")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xauxwhat/text")) {
                this.data = new StringBuilder();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack")) {
                this.currentStacktrace = new ValgrindStacktrace();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/suppression/rawtext")) {
                this.data = new StringBuilder();
            }
            if (this.currentStacktrace != null) {
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame")) {
                    this.currentStacktraceFrame = new ValgrindStacktraceFrame();
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/obj") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/obj")) {
                    this.data = new StringBuilder();
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/fn") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/fn")) {
                    this.data = new StringBuilder();
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/dir") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/dir")) {
                    this.data = new StringBuilder();
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/file") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/file")) {
                    this.data = new StringBuilder();
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/line") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/line")) {
                    this.data = new StringBuilder();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread") && this.currentProcess != null) {
                this.currentProcess.addThread(this.currentThread);
                this.currentThread = null;
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread/hthreadid") && this.currentThread != null) {
                this.currentThread.setHthreadid(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack") && this.currentThread != null) {
                if (this.currentThread.getStacktrace() == null) {
                    this.currentThread.setStacktrace(this.currentStacktrace);
                }
                this.currentStacktrace = null;
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error")) {
                if (this.currentAuxiliary != null) {
                    this.currentError.addAuxiliaryData(this.currentAuxiliary);
                }
                if (this.currentError.getKind() != null && this.currentProcess != null) {
                    this.currentProcess.addError(this.currentError);
                }
                this.currentError = null;
                this.currentAuxiliary = null;
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/unique")) {
                this.currentError.setUniqueId(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/pid") && this.currentProcess != null) {
                this.currentProcess.setPid(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/ppid") && this.currentProcess != null) {
                this.currentProcess.setPpid(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/kind")) {
                try {
                    this.currentError.setKind(ValgrindErrorKind.valueOf(this.data.toString()));
                }
                catch (IllegalArgumentException e) {
                    ValgrindLogger.logWarn("Valgrind error not supported: " + this.data.toString());
                }
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/what")) {
                this.currentError.setDescription(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/auxwhat") && this.currentError != null) {
                if (this.currentAuxiliary != null) {
                    this.currentError.addAuxiliaryData(this.currentAuxiliary);
                }
                this.currentAuxiliary = new ValgrindAuxiliary();
                this.currentAuxiliary.setDescription(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xauxwhat/text")) {
                this.currentText = this.data.toString();
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xauxwhat")) {
                if (this.currentAuxiliary != null) {
                    this.currentError.addAuxiliaryData(this.currentAuxiliary);
                }
                this.currentAuxiliary = new ValgrindAuxiliary();
                this.currentAuxiliary.setDescription(this.currentText);
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/argv/exe") && this.currentProcess != null) {
                this.currentProcess.setExecutable(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/argv/arg") && this.currentProcess != null) {
                this.currentProcess.addArgument(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/args/vargv/arg") && this.currentProcess != null) {
                this.currentProcess.addValgrindArgument(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/text")) {
                this.currentError.setDescription(this.data.toString());
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/leakedbytes")) {
                try {
                    this.currentError.setLeakedBytes(Integer.valueOf(this.data.toString()));
                }
                catch (NumberFormatException e) {
                    ValgrindLogger.logWarn("'" + this.data.toString() + "' is not a valid number of leaked bytes");
                }
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/xwhat/leakedblocks")) {
                try {
                    this.currentError.setLeakedBlocks(Integer.valueOf(this.data.toString()));
                }
                catch (NumberFormatException e) {
                    ValgrindLogger.logWarn("'" + this.data.toString() + "' is not a valid number of leaked blocks");
                }
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack") && this.currentStacktrace != null) {
                if (this.currentAuxiliary != null) {
                    this.currentAuxiliary.setStacktrace(this.currentStacktrace);
                } else if (this.currentError.getStacktrace() == null) {
                    this.currentError.setStacktrace(this.currentStacktrace);
                }
                this.currentStacktrace = null;
            }
            if (this.currentStacktraceFrame != null) {
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame")) {
                    this.currentStacktrace.addFrame(this.currentStacktraceFrame);
                    this.currentStacktraceFrame = null;
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/obj") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/obj")) {
                    this.currentStacktraceFrame.setObjectName(this.data.toString());
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/fn") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/fn")) {
                    this.currentStacktraceFrame.setFunctionName(this.data.toString());
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/dir") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/dir")) {
                    this.currentStacktraceFrame.setDirectoryName(this.data.toString());
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/file") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/file")) {
                    this.currentStacktraceFrame.setFileName(this.data.toString());
                }
                if (this.path.equalsIgnoreCase("/valgrindoutput/error/stack/frame/line") || this.path.equalsIgnoreCase("/valgrindoutput/announcethread/stack/frame/line")) {
                    try {
                        this.currentStacktraceFrame.setLineNumber(Integer.valueOf(this.data.toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (this.path.equalsIgnoreCase("/valgrindoutput/error/suppression/rawtext") && this.currentError != null && this.data != null) {
                this.currentError.setSuppression(this.data.toString().trim());
            }
            this.data = null;
            this.path = this.path.substring(0, this.path.length() - (qName.length() + 1));
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.data == null) {
                return;
            }
            this.data.append(new String(ch, start, length));
        }

        public ValgrindReport getReport() {
            return this.currentReport;
        }
    }
}

