/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktrace;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceFile;

public class ValgrindThread
implements Serializable {
    private static final long serialVersionUID = 6470943829358084901L;
    private String hthreadid;
    private ValgrindStacktrace stacktrace;
    private boolean rootThread;

    public String toString() {
        if (this.hthreadid != null && this.stacktrace != null) {
            return "id: " + this.hthreadid + "\nroot_thread: " + this.rootThread + "\nstack: " + this.stacktrace.toString();
        }
        return "";
    }

    public void setSourceCode(ValgrindSourceFile sourceFile) {
        if (this.stacktrace != null) {
            this.stacktrace.setSourceCode(sourceFile);
        }
    }

    public ValgrindStacktrace getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(ValgrindStacktrace stacktrace) {
        this.stacktrace = stacktrace;
    }

    public String getDescription() {
        if (this.rootThread) {
            return "Root Thread (Helgrind ID " + this.hthreadid + ")";
        }
        return "Spawned Thread (Helgrind ID " + this.hthreadid + ")";
    }

    public void setHthreadid(String hthreadid) {
        this.hthreadid = hthreadid;
    }

    public String getHthreadid() {
        return this.hthreadid;
    }

    public boolean isRootThread() {
        return this.rootThread;
    }

    public void setRootThread(boolean rootThread) {
        this.rootThread = rootThread;
    }
}

