/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import org.jenkinsci.plugins.valgrind.util.ValgrindUtil;

public class ValgrindStacktraceFrame
implements Serializable {
    private static final long serialVersionUID = -2774574337822108808L;
    private String objectName;
    private String directoryName;
    private String fileName;
    private Integer lineNumber;
    private String functionName;
    private transient String sourceCode = null;

    public String toString() {
        return "object    : " + this.objectName + "\nfunction  : " + this.functionName + "\ndirectory : " + this.directoryName + "\nfile      : " + this.fileName + "\nlineNumber: " + this.lineNumber;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = ValgrindUtil.trimToNull(objectName);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = ValgrindUtil.trimToNull(directoryName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = ValgrindUtil.trimToNull(fileName);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = ValgrindUtil.trimToNull(functionName);
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = ValgrindUtil.trimToNull(sourceCode);
    }

    public String getFilePath() {
        if (this.directoryName == null && this.fileName == null) {
            return null;
        }
        if (this.directoryName == null) {
            return this.fileName;
        }
        if (this.fileName == null) {
            return this.directoryName;
        }
        return this.directoryName + "/" + this.fileName;
    }

    public String getFilePathAndLine() {
        String filePath = this.getFilePath();
        if (filePath == null && this.lineNumber == null) {
            return null;
        }
        if (this.lineNumber == null) {
            return filePath;
        }
        if (filePath == null) {
            return this.lineNumber.toString();
        }
        return filePath + ":" + this.lineNumber;
    }
}

