/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.valgrind.model.ValgrindStacktraceFrame;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceFile;

public class ValgrindStacktrace
implements Serializable {
    private static final long serialVersionUID = 3165729611300651095L;
    private List<ValgrindStacktraceFrame> frames;

    public void setSourceCode(ValgrindSourceFile sourceFile) {
        if (this.frames == null) {
            return;
        }
        for (ValgrindStacktraceFrame frame : this.frames) {
            if (frame == null) continue;
            frame.setSourceCode(sourceFile.getSnippet(frame.getFilePath(), frame.getLineNumber()));
        }
    }

    public String toString() {
        if (this.frames == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (ValgrindStacktraceFrame frame : this.frames) {
            buf.append(frame.toString() + "\n\n");
        }
        return buf.toString();
    }

    public String getFileSummary() {
        if (this.frames == null) {
            throw new IllegalStateException("valgrind stacktrace is empty");
        }
        ArrayList<String> files = new ArrayList<String>();
        for (ValgrindStacktraceFrame frame : this.frames) {
            files.add(frame.getFileName() + "(" + frame.getLineNumber() + ")");
        }
        return StringUtils.join(files, (String)", ");
    }

    public void addFrame(ValgrindStacktraceFrame frame) {
        if (this.frames == null) {
            this.frames = new ArrayList<ValgrindStacktraceFrame>();
        }
        this.frames.add(frame);
    }

    public int size() {
        if (this.frames == null) {
            return 0;
        }
        return this.frames.size();
    }

    public boolean isEmpty() {
        return this.frames == null || this.frames.isEmpty();
    }

    public ValgrindStacktraceFrame getFrame(int index) {
        if (this.isEmpty() || this.frames == null) {
            throw new IllegalStateException("valgrind stacktrace is empty");
        }
        return this.frames.get(index);
    }

    public List<ValgrindStacktraceFrame> getFrames() {
        return this.frames;
    }

    public void setFrames(List<ValgrindStacktraceFrame> frames) {
        this.frames = frames;
    }
}

