/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindProcess;
import org.jenkinsci.plugins.valgrind.model.ValgrindThread;
import org.jenkinsci.plugins.valgrind.util.ValgrindErrorList;

public class ValgrindReport
implements Serializable {
    private static final long serialVersionUID = -9036045639715893780L;
    @Deprecated
    private List<ValgrindError> errors;
    @Deprecated
    private Set<String> executables;
    private List<ValgrindProcess> processes;
    private Map<String, String> parserErrors;

    public boolean isValid() {
        if (this.processes == null || this.processes.isEmpty()) {
            return false;
        }
        for (ValgrindProcess p : this.processes) {
            if (p.isValid()) continue;
            return false;
        }
        return true;
    }

    public void addProcess(ValgrindProcess process) {
        if (this.processes == null) {
            this.processes = new ArrayList<ValgrindProcess>();
        }
        this.processes.add(process);
    }

    public void addParserError(String filename, String errorMessage) {
        if (this.parserErrors == null) {
            this.parserErrors = new HashMap<String, String>();
        }
        this.parserErrors.put(filename, errorMessage);
    }

    public boolean hasParserErrors() {
        return this.parserErrors != null && !this.parserErrors.isEmpty();
    }

    public Map<String, String> getParserErrors() {
        return this.parserErrors;
    }

    public List<ValgrindError> getAllErrors() {
        ArrayList<ValgrindError> list = new ArrayList<ValgrindError>();
        if (this.processes != null) {
            for (ValgrindProcess p : this.processes) {
                List<ValgrindError> l = p.getErrors();
                if (l == null) continue;
                list.addAll(l);
            }
        }
        if (this.errors != null) {
            list.addAll(this.errors);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public void integrate(ValgrindReport valgrindReport) {
        if (valgrindReport == null || valgrindReport.processes == null) {
            return;
        }
        if (this.processes == null) {
            this.processes = new ArrayList<ValgrindProcess>();
        }
        this.processes.addAll(valgrindReport.processes);
    }

    public ValgrindError findError(String pid, String uniqueId) {
        if (this.errors != null) {
            for (ValgrindError error : this.errors) {
                if (!error.getUniqueId().equals(uniqueId) || !error.getExecutable().equals(pid)) continue;
                return error;
            }
        }
        ValgrindProcess process = this.findProcess(pid);
        return process.findErrorByUniqueId(uniqueId);
    }

    public ValgrindProcess findProcess(String pid) {
        if (this.processes != null) {
            for (ValgrindProcess process : this.processes) {
                if (!process.getPid().equals(pid)) continue;
                process.setupParentChilds(this.processes);
                return process;
            }
        }
        ValgrindProcess process = new ValgrindProcess();
        process.setExecutable(pid);
        process.setPid(pid);
        if (this.errors != null) {
            for (ValgrindError error : this.errors) {
                if (!error.getExecutable().equals(pid)) continue;
                process.addError(error);
            }
        }
        return process;
    }

    public ValgrindErrorList getErrorList() {
        return new ValgrindErrorList(this.getAllErrors());
    }

    public List<ValgrindProcess> getProcesses() {
        ArrayList<ValgrindProcess> result = new ArrayList<ValgrindProcess>();
        if (this.processes != null) {
            for (ValgrindProcess valgrindProcess : this.processes) {
                if (!valgrindProcess.isValid()) continue;
                result.add(valgrindProcess);
            }
        }
        if (this.errors != null) {
            HashMap<String, ValgrindProcess> lookup = new HashMap<String, ValgrindProcess>();
            for (ValgrindError error : this.errors) {
                if (!lookup.containsKey(error.getExecutable())) {
                    ValgrindProcess process = new ValgrindProcess();
                    process.setExecutable(error.getExecutable());
                    process.setPid(error.getExecutable());
                    lookup.put(error.getExecutable(), process);
                }
                ((ValgrindProcess)lookup.get(error.getExecutable())).addError(error);
            }
            for (ValgrindProcess p : lookup.values()) {
                if (!p.isValid()) continue;
                result.add(p);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        for (ValgrindProcess valgrindProcess : result) {
            valgrindProcess.setupParentChilds(this.processes);
        }
        return result;
    }

    public ValgrindThread findThread(String pid, String hthreadid) {
        ValgrindProcess process = this.findProcess(pid);
        return process.findThreadByHthreadid(hthreadid);
    }
}

