/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.config;

import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class ValgrindPublisherConfig
implements Serializable {
    private static final long serialVersionUID = 1335068144678253494L;
    private String pattern = "*.memcheck";
    private String failThresholdInvalidReadWrite;
    private String failThresholdDefinitelyLost;
    private String failThresholdTotal;
    private String unstableThresholdInvalidReadWrite;
    private String unstableThresholdDefinitelyLost;
    private String unstableThresholdTotal;
    private String sourceSubstitutionPaths;
    private boolean publishResultsForAbortedBuilds;
    private boolean publishResultsForFailedBuilds;
    private boolean failBuildOnMissingReports;
    private boolean failBuildOnInvalidReports;

    private static String saveTrim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    @DataBoundConstructor
    public ValgrindPublisherConfig(String pattern, String failThresholdInvalidReadWrite, String failThresholdDefinitelyLost, String failThresholdTotal, String unstableThresholdInvalidReadWrite, String unstableThresholdDefinitelyLost, String unstableThresholdTotal, String sourceSubstitutionPaths, boolean publishResultsForAbortedBuilds, boolean publishResultsForFailedBuilds, boolean failBuildOnMissingReports, boolean failBuildOnInvalidReports) {
        this.pattern = pattern.trim();
        this.failThresholdInvalidReadWrite = ValgrindPublisherConfig.saveTrim(failThresholdInvalidReadWrite);
        this.failThresholdDefinitelyLost = ValgrindPublisherConfig.saveTrim(failThresholdDefinitelyLost);
        this.failThresholdTotal = ValgrindPublisherConfig.saveTrim(failThresholdTotal);
        this.unstableThresholdInvalidReadWrite = ValgrindPublisherConfig.saveTrim(unstableThresholdInvalidReadWrite);
        this.unstableThresholdDefinitelyLost = ValgrindPublisherConfig.saveTrim(unstableThresholdDefinitelyLost);
        this.unstableThresholdTotal = ValgrindPublisherConfig.saveTrim(unstableThresholdTotal);
        this.sourceSubstitutionPaths = ValgrindPublisherConfig.saveTrim(sourceSubstitutionPaths);
        this.publishResultsForAbortedBuilds = publishResultsForAbortedBuilds;
        this.publishResultsForFailedBuilds = publishResultsForFailedBuilds;
        this.failBuildOnMissingReports = failBuildOnMissingReports;
        this.failBuildOnInvalidReports = failBuildOnInvalidReports;
    }

    public ValgrindPublisherConfig() {
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFailThresholdInvalidReadWrite() {
        return this.failThresholdInvalidReadWrite;
    }

    public String getFailThresholdDefinitelyLost() {
        return this.failThresholdDefinitelyLost;
    }

    public String getFailThresholdTotal() {
        return this.failThresholdTotal;
    }

    public String getUnstableThresholdInvalidReadWrite() {
        return this.unstableThresholdInvalidReadWrite;
    }

    public String getUnstableThresholdDefinitelyLost() {
        return this.unstableThresholdDefinitelyLost;
    }

    public String getUnstableThresholdTotal() {
        return this.unstableThresholdTotal;
    }

    public String getSourceSubstitutionPaths() {
        return this.sourceSubstitutionPaths;
    }

    public boolean isPublishResultsForAbortedBuilds() {
        return this.publishResultsForAbortedBuilds;
    }

    public boolean isPublishResultsForFailedBuilds() {
        return this.publishResultsForFailedBuilds;
    }

    public boolean isFailBuildOnMissingReports() {
        return this.failBuildOnMissingReports;
    }

    public boolean isFailBuildOnInvalidReports() {
        return this.failBuildOnInvalidReports;
    }
}

