/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValgrindVersion {
    public final int major;
    public final int minor;
    public final int patch;

    private ValgrindVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean isGreaterOrEqual(ValgrindVersion other) {
        if (this.major < other.major) {
            return false;
        }
        if (this.major > other.major) {
            return true;
        }
        if (this.minor < other.minor) {
            return false;
        }
        if (this.minor > other.minor) {
            return true;
        }
        return this.patch >= other.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public static ValgrindVersion createInstance(int major, int minor, int patch) {
        return new ValgrindVersion(major, minor, patch);
    }

    public static ValgrindVersion createInstance(int major, int minor) {
        return ValgrindVersion.createInstance(major, minor, 0);
    }

    public static ValgrindVersion createInstance(int major) {
        return ValgrindVersion.createInstance(major, 0);
    }

    public static ValgrindVersion createInstanceFromString(String versionString) {
        if (versionString == null) {
            return null;
        }
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher m = p.matcher(versionString);
        if (!m.find()) {
            return null;
        }
        return ValgrindVersion.createInstance(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
    }
}

