/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind.call;

import org.jenkinsci.plugins.valgrind.call.ValgrindOption;
import org.jenkinsci.plugins.valgrind.call.ValgrindOptionNotApplicableException;
import org.jenkinsci.plugins.valgrind.call.ValgrindVersion;

public class ValgrindEnumOption<E>
implements ValgrindOption {
    private final String name;
    private final E value;
    private final ValgrindVersion minimumVersion;

    public ValgrindEnumOption(String name, E value, E defaultValue) {
        this.name = name;
        this.value = value != null ? value : defaultValue;
        this.minimumVersion = ValgrindVersion.createInstance(0);
    }

    public ValgrindEnumOption(String name, E value, E defaultValue, ValgrindVersion valgrindVersion) {
        this.name = name;
        this.value = value != null ? value : defaultValue;
        this.minimumVersion = valgrindVersion;
    }

    @Override
    public String getArgumentString(ValgrindVersion valgrindVersion) throws ValgrindOptionNotApplicableException {
        if (!valgrindVersion.isGreaterOrEqual(this.minimumVersion)) {
            throw new ValgrindOptionNotApplicableException("valgrind version " + this.minimumVersion.toString() + " required");
        }
        if (this.value == null) {
            throw new ValgrindOptionNotApplicableException("no value");
        }
        return "--" + this.name + "=" + this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public E getValue() {
        return this.value;
    }
}

