/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind;

import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.valgrind.ValgrindBuildAction;
import org.jenkinsci.plugins.valgrind.ValgrindErrorDetail;
import org.jenkinsci.plugins.valgrind.ValgrindProcessDetails;
import org.jenkinsci.plugins.valgrind.ValgrindPublisher;
import org.jenkinsci.plugins.valgrind.ValgrindThreadDetail;
import org.jenkinsci.plugins.valgrind.config.ValgrindPublisherConfig;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindProcess;
import org.jenkinsci.plugins.valgrind.model.ValgrindReport;
import org.jenkinsci.plugins.valgrind.model.ValgrindThread;
import org.jenkinsci.plugins.valgrind.parser.ValgrindParserResult;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceFile;
import org.jenkinsci.plugins.valgrind.util.ValgrindSummary;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ValgrindResult
implements Serializable {
    private static final long serialVersionUID = -5347879997716170059L;
    private static final String PID_TOKEN = "pid=";
    private ValgrindParserResult parser;
    private transient Run<?, ?> owner;
    private Map<String, String> sourceFiles;

    public ValgrindResult(Run<?, ?> build, ValgrindParserResult parser) {
        this.owner = build;
        this.parser = parser;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public ValgrindPublisherConfig getConfig() {
        ValgrindBuildAction action = (ValgrindBuildAction)this.owner.getAction(ValgrindBuildAction.class);
        if (action == null) {
            return null;
        }
        return action.getConfig();
    }

    public ValgrindReport getReport() throws IOException, InterruptedException {
        FilePath file = new FilePath(this.owner.getRootDir());
        return (ValgrindReport)file.act((FilePath.FileCallable)this.parser);
    }

    public Map<String, String> getSourceFiles() {
        return this.sourceFiles;
    }

    public void setSourceFiles(Map<String, String> sourceFiles) {
        this.sourceFiles = sourceFiles;
    }

    public String getSummary() throws IOException, InterruptedException {
        return ValgrindSummary.createReportSummary(this);
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) throws IOException, InterruptedException {
        String[] s = link.split("/");
        String data = s[s.length - 1];
        if (!data.startsWith(PID_TOKEN)) {
            return null;
        }
        int sep = data.indexOf(",");
        ValgrindReport report = this.getReport();
        if (sep > PID_TOKEN.length()) {
            String pid = data.substring(PID_TOKEN.length(), sep);
            String uniqueId = data.substring(sep + 1);
            if (uniqueId.startsWith("tid")) {
                ValgrindThread thread = report.findThread(pid, uniqueId.substring(3));
                if (thread == null) {
                    return null;
                }
                ValgrindSourceFile sourceFile = new ValgrindSourceFile(ValgrindPublisher.DESCRIPTOR.getLinesBefore(), ValgrindPublisher.DESCRIPTOR.getLinesAfter(), this.sourceFiles, this.owner);
                return new ValgrindThreadDetail(this.owner, report.findProcess(pid), thread, sourceFile);
            }
            ValgrindError error = report.findError(pid, uniqueId);
            if (error == null) {
                return null;
            }
            ValgrindSourceFile sourceFile = new ValgrindSourceFile(ValgrindPublisher.DESCRIPTOR.getLinesBefore(), ValgrindPublisher.DESCRIPTOR.getLinesAfter(), this.sourceFiles, this.owner);
            return new ValgrindErrorDetail(this.owner, report.findProcess(pid), error, sourceFile);
        }
        String pid = data.substring(PID_TOKEN.length());
        ValgrindProcess process = report.findProcess(pid);
        return new ValgrindProcessDetails(this.owner, process);
    }
}

