/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.valgrind.ValgrindBuildAction;
import org.jenkinsci.plugins.valgrind.ValgrindResult;
import org.jenkinsci.plugins.valgrind.ValgrindResultsScanner;
import org.jenkinsci.plugins.valgrind.config.ValgrindPublisherConfig;
import org.jenkinsci.plugins.valgrind.model.ValgrindAuxiliary;
import org.jenkinsci.plugins.valgrind.model.ValgrindError;
import org.jenkinsci.plugins.valgrind.model.ValgrindProcess;
import org.jenkinsci.plugins.valgrind.model.ValgrindReport;
import org.jenkinsci.plugins.valgrind.parser.ValgrindParserResult;
import org.jenkinsci.plugins.valgrind.util.ValgrindEvaluator;
import org.jenkinsci.plugins.valgrind.util.ValgrindLogger;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceGrabber;
import org.jenkinsci.plugins.valgrind.util.ValgrindSourceResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ValgrindPublisher
extends Recorder
implements SimpleBuildStep {
    private ValgrindPublisherConfig valgrindPublisherConfig;
    @Extension
    public static final ValgrindPublisherDescriptor DESCRIPTOR = new ValgrindPublisherDescriptor();

    @DataBoundConstructor
    public ValgrindPublisher(String pattern, String failThresholdInvalidReadWrite, String failThresholdDefinitelyLost, String failThresholdTotal, String unstableThresholdInvalidReadWrite, String unstableThresholdDefinitelyLost, String unstableThresholdTotal, String sourceSubstitutionPaths, boolean publishResultsForAbortedBuilds, boolean publishResultsForFailedBuilds, boolean failBuildOnMissingReports, boolean failBuildOnInvalidReports) {
        this.valgrindPublisherConfig = new ValgrindPublisherConfig(pattern, failThresholdInvalidReadWrite, failThresholdDefinitelyLost, failThresholdTotal, unstableThresholdInvalidReadWrite, unstableThresholdDefinitelyLost, unstableThresholdTotal, sourceSubstitutionPaths, publishResultsForAbortedBuilds, publishResultsForFailedBuilds, failBuildOnMissingReports, failBuildOnInvalidReports);
    }

    public ValgrindPublisherDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected boolean canContinue(Result result) {
        if (result == Result.ABORTED && !this.valgrindPublisherConfig.isPublishResultsForAbortedBuilds()) {
            return false;
        }
        return result != Result.FAILURE || this.valgrindPublisherConfig.isPublishResultsForFailedBuilds();
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (!this.canContinue(build.getResult())) {
            return;
        }
        if (this.valgrindPublisherConfig.getPattern() == null || this.valgrindPublisherConfig.getPattern().isEmpty()) {
            ValgrindLogger.log(listener, "ERROR: no pattern for valgrind xml files configured");
            return;
        }
        EnvVars env = build.getEnvironment(listener);
        FilePath baseFileFrom = workspace;
        FilePath baseFileTo = new FilePath(build.getRootDir());
        ValgrindResultsScanner scanner = new ValgrindResultsScanner(this.valgrindPublisherConfig.getPattern());
        String[] files = (String[])baseFileFrom.act((FilePath.FileCallable)scanner);
        if (files.length == 0 && this.valgrindPublisherConfig.isFailBuildOnMissingReports()) {
            ValgrindLogger.log(listener, "ERROR: no report files found for pattern '" + this.valgrindPublisherConfig.getPattern() + "'");
            build.setResult(Result.FAILURE);
        } else {
            ValgrindSourceResolver sourceResolver;
            ValgrindSourceGrabber sourceGrabber;
            int i;
            ValgrindLogger.log(listener, "Files to copy:");
            for (i = 0; i < files.length; ++i) {
                ValgrindLogger.log(listener, files[i]);
            }
            for (i = 0; i < files.length; ++i) {
                FilePath fileFrom = new FilePath(baseFileFrom, files[i]);
                FilePath fileTo = new FilePath(baseFileTo, "valgrind-plugin/valgrind-results/" + files[i]);
                ValgrindLogger.log(listener, "Copying " + files[i] + " to " + fileTo.getRemote());
                fileFrom.copyTo(fileTo);
            }
            ValgrindParserResult parser = new ValgrindParserResult("valgrind-plugin/valgrind-results/" + this.valgrindPublisherConfig.getPattern());
            ValgrindResult valgrindResult = new ValgrindResult(build, parser);
            ValgrindReport valgrindReport = valgrindResult.getReport();
            this.logParserError(listener, valgrindReport);
            new ValgrindEvaluator(this.valgrindPublisherConfig, listener).evaluate(valgrindReport, build, env);
            ValgrindLogger.log(listener, "Analysing valgrind results");
            String resolvedSubstitutionPaths = this.valgrindPublisherConfig.getSourceSubstitutionPaths();
            if (env != null) {
                resolvedSubstitutionPaths = env.expand(resolvedSubstitutionPaths);
            }
            if (!(sourceGrabber = new ValgrindSourceGrabber(listener, workspace, sourceResolver = new ValgrindSourceResolver(resolvedSubstitutionPaths))).init(build.getRootDir())) {
                return;
            }
            if (valgrindReport.getAllErrors() != null) {
                for (ValgrindError error : valgrindReport.getAllErrors()) {
                    if (error.getStacktrace() != null) {
                        sourceGrabber.grabFromStacktrace(error.getStacktrace());
                    }
                    if (error.getAuxiliaryData() == null) continue;
                    for (ValgrindAuxiliary aux : error.getAuxiliaryData()) {
                        if (aux.getStacktrace() == null) continue;
                        sourceGrabber.grabFromStacktrace(aux.getStacktrace());
                    }
                }
            }
            if (valgrindReport.getProcesses() != null) {
                String workspacePath = workspace.getRemote() + "/";
                ValgrindLogger.log(listener, "workspacePath: " + workspacePath);
                for (ValgrindProcess p : valgrindReport.getProcesses()) {
                    if (!p.isValid()) continue;
                    if (p.getExecutable().startsWith(workspacePath)) {
                        p.setExecutable(p.getExecutable().substring(workspacePath.length()));
                    }
                    if (!p.getExecutable().startsWith("./")) continue;
                    p.setExecutable(p.getExecutable().substring(2));
                }
            }
            valgrindResult.setSourceFiles(sourceGrabber.getLookupMap());
            ValgrindBuildAction buildAction = new ValgrindBuildAction(build, valgrindResult, this.valgrindPublisherConfig);
            build.addAction((Action)buildAction);
            ValgrindLogger.log(listener, "Ending the valgrind analysis.");
        }
    }

    public ValgrindPublisherConfig getValgrindPublisherConfig() {
        return this.valgrindPublisherConfig;
    }

    public void setValgrindPublisherConfig(ValgrindPublisherConfig valgrindPublisherConfig) {
        this.valgrindPublisherConfig = valgrindPublisherConfig;
    }

    private void logParserError(TaskListener listener, ValgrindReport report) {
        if (report == null || report.getParserErrors() == null) {
            return;
        }
        for (Map.Entry<String, String> entry : report.getParserErrors().entrySet()) {
            ValgrindLogger.log(listener, "ERROR: failed to parse " + entry.getKey() + ": " + entry.getValue());
        }
    }

    public String getPattern() {
        return this.valgrindPublisherConfig.getPattern();
    }

    public String getFailThresholdInvalidReadWrite() {
        return this.valgrindPublisherConfig.getFailThresholdInvalidReadWrite();
    }

    public String getFailThresholdDefinitelyLost() {
        return this.valgrindPublisherConfig.getFailThresholdDefinitelyLost();
    }

    public String getFailThresholdTotal() {
        return this.valgrindPublisherConfig.getFailThresholdTotal();
    }

    public String getUnstableThresholdInvalidReadWrite() {
        return this.valgrindPublisherConfig.getUnstableThresholdInvalidReadWrite();
    }

    public String getUnstableThresholdDefinitelyLost() {
        return this.valgrindPublisherConfig.getUnstableThresholdDefinitelyLost();
    }

    public String getUnstableThresholdTotal() {
        return this.valgrindPublisherConfig.getUnstableThresholdTotal();
    }

    public String getSourceSubstitutionPaths() {
        return this.valgrindPublisherConfig.getSourceSubstitutionPaths();
    }

    public boolean isPublishResultsForAbortedBuilds() {
        return this.valgrindPublisherConfig.isPublishResultsForAbortedBuilds();
    }

    public boolean isPublishResultsForFailedBuilds() {
        return this.valgrindPublisherConfig.isPublishResultsForFailedBuilds();
    }

    public boolean isFailBuildOnMissingReports() {
        return this.valgrindPublisherConfig.isFailBuildOnMissingReports();
    }

    public boolean isFailBuildOnInvalidReports() {
        return this.valgrindPublisherConfig.isFailBuildOnInvalidReports();
    }

    public static final class ValgrindPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        private int linesBefore = 10;
        private int linesAfter = 5;

        public ValgrindPublisherDescriptor() {
            super(ValgrindPublisher.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.linesBefore = formData.getInt("linesBefore");
            this.linesAfter = formData.getInt("linesAfter");
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Valgrind results";
        }

        public int getLinesBefore() {
            return this.linesBefore;
        }

        public int getLinesAfter() {
            return this.linesAfter;
        }

        public ValgrindPublisherConfig getConfig() {
            return new ValgrindPublisherConfig();
        }
    }
}

