/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.valgrind;

import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.valgrind.ValgrindProjectAction;
import org.jenkinsci.plugins.valgrind.ValgrindResult;
import org.jenkinsci.plugins.valgrind.config.ValgrindPublisherConfig;
import org.jenkinsci.plugins.valgrind.graph.ValgrindGraph;
import org.jenkinsci.plugins.valgrind.model.ValgrindReport;
import org.jenkinsci.plugins.valgrind.util.AbstractValgrindBuildAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ValgrindBuildAction
extends AbstractValgrindBuildAction
implements SimpleBuildStep.LastBuildAction {
    public static final String URL_NAME = "valgrindResult";
    private ValgrindResult result;
    private ValgrindPublisherConfig config;

    public ValgrindBuildAction(Run<?, ?> owner, ValgrindResult result, ValgrindPublisherConfig config) {
        super(owner);
        this.result = result;
        this.config = config;
    }

    public Run<?, ?> getBuild() {
        return this.owner;
    }

    public ValgrindResult getResult() {
        return this.result;
    }

    public ValgrindPublisherConfig getConfig() {
        return this.config;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        return new HealthReport();
    }

    public String getIconFileName() {
        return "/plugin/valgrind/icons/valgrind-48.png";
    }

    public String getDisplayName() {
        return "Valgrind Result";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Override
    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException, InterruptedException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar timestamp = this.getBuild().getTimestamp();
        if (req.checkIfModified(timestamp, rsp)) {
            return;
        }
        ValgrindGraph g = new ValgrindGraph(this.getOwner(), this.getDataSetBuilder().build(), "Number of errors", 500, 250);
        g.doPng(req, rsp);
    }

    private DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder() throws IOException, InterruptedException {
        DataSetBuilder dsb = new DataSetBuilder();
        for (ValgrindBuildAction buildAction = this; buildAction != null; buildAction = (ValgrindBuildAction)((Object)buildAction.getPreviousResult())) {
            Run run = buildAction.owner;
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(run);
            ValgrindReport report = buildAction.getResult().getReport();
            dsb.add((Number)(report.getErrorList().getInvalidReadErrorCount() + report.getErrorList().getInvalidWriteErrorCount()), (Comparable)((Object)"Invalid reads/writes"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getLeakDefinitelyLostErrorCount(), (Comparable)((Object)"Leaks (definitely lost)"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getLeakPossiblyLostErrorCount(), (Comparable)((Object)"Leaks (possibly lost)"), (Comparable)label);
            dsb.add((Number)(report.getErrorList().getUninitializedConditionErrorCount() + report.getErrorList().getUninitializedValueErrorCount()), (Comparable)((Object)"Uninitialized value/cond."), (Comparable)label);
            dsb.add((Number)(report.getErrorList().getInvalidFreeErrorCount() + report.getErrorList().getMismatchedFreeErrorCount()), (Comparable)((Object)"Illegal/mismatched frees"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getOverlapErrorCount(), (Comparable)((Object)"Overlaps"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getSyscallParamErrorCount(), (Comparable)((Object)"Illegal system calls"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getRaceErrorCount(), (Comparable)((Object)"Data races"), (Comparable)label);
            dsb.add((Number)(report.getErrorList().getUnlockUnlockedErrorCount() + report.getErrorList().getUnlockForeignErrorCount() + report.getErrorList().getUnlockBogusErrorCount()), (Comparable)((Object)"Unlock issues"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getLockOrderErrorCount(), (Comparable)((Object)"Lock order"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getPthAPIErrorCount(), (Comparable)((Object)"Pthread API"), (Comparable)label);
            dsb.add((Number)report.getErrorList().getMiscErrorCount(), (Comparable)((Object)"Helgrind misc"), (Comparable)label);
        }
        return dsb;
    }

    public Collection<? extends Action> getProjectActions() {
        ArrayList<ValgrindProjectAction> projectActions = new ArrayList<ValgrindProjectAction>();
        projectActions.add(new ValgrindProjectAction(this.owner.getParent()));
        return projectActions;
    }
}

