/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content.json.util;

import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.jenkinsci.lib.xtrigger.XTriggerException;

public class JsonUtils {
    public static void validateJson(String content) throws XTriggerException {
        block4: {
            try {
                JsonParser parser = new JsonFactory().createJsonParser(content.getBytes(Charset.forName("UTF-8")));
                JsonToken currentToken = parser.nextToken();
                if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                    JsonUtils.validateObject(parser);
                    break block4;
                }
                if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                    JsonUtils.validateArray(parser);
                    break block4;
                }
                throw new XTriggerException("Bad Json value starting with: " + currentToken.toString());
            }
            catch (IOException ex) {
                throw new XTriggerException("Bad Json value: " + ex.getMessage());
            }
        }
    }

    private static void validateObject(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextValue();
        while (currentToken != null && !currentToken.equals((Object)JsonToken.END_OBJECT)) {
            if (currentToken.toString().startsWith("VALUE_")) {
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                JsonUtils.validateArray(parser);
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                JsonUtils.validateObject(parser);
                currentToken = parser.nextValue();
                continue;
            }
            throw new IOException("Expected object/array start, found: " + currentToken.toString());
        }
    }

    private static void validateArray(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextValue();
        while (currentToken != null && !currentToken.equals((Object)JsonToken.END_ARRAY)) {
            if (currentToken.toString().startsWith("VALUE_")) {
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                JsonUtils.validateArray(parser);
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                JsonUtils.validateObject(parser);
                currentToken = parser.nextValue();
                continue;
            }
            throw new IOException("Expected object/array start, found: " + currentToken.toString());
        }
    }
}

