/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.twitter.messages;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.User;
import hudson.plugins.twitter.UserTwitterProperty;
import hudson.plugins.twitter.messages.LinkGenerator;
import hudson.plugins.twitter.messages.TweetBuilder;
import hudson.scm.ChangeLogSet;
import java.util.Set;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTweetBuilder
implements TweetBuilder {
    private static final String TWEET_FORMAT = "%s%s:%s $%d - %s";
    private LinkGenerator linkGenerator;

    public DefaultTweetBuilder(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    @Override
    public String generateTweet(AbstractBuild<?, ?> build, boolean includeBuildUrl) {
        String projectName = build.getProject().getName();
        String result = build.getResult().toString();
        String toBlame = this.getUserString(build);
        String shortenedUrl = "";
        if (includeBuildUrl) {
            String absoluteBuildURL = Jenkins.getInstance().getRootUrl() + build.getUrl();
            try {
                shortenedUrl = this.linkGenerator.getShortenedLink(absoluteBuildURL);
            }
            catch (Exception e) {
                shortenedUrl = "?";
            }
        }
        return String.format(TWEET_FORMAT, toBlame, result, projectName, build.number, shortenedUrl);
    }

    private String getUserString(AbstractBuild<?, ?> build) {
        StringBuilder userString;
        block4: {
            ChangeLogSet changeSet;
            block3: {
                if (build.getResult().equals(Result.SUCCESS)) {
                    return "";
                }
                userString = new StringBuilder();
                Set culprits = build.getCulprits();
                changeSet = build.getChangeSet();
                if (culprits.size() <= 0) break block3;
                for (User user : culprits) {
                    this.addUserToBuilder(user, userString);
                }
                break block4;
            }
            if (changeSet == null) break block4;
            for (ChangeLogSet.Entry entry : changeSet) {
                this.addUserToBuilder(entry.getAuthor(), userString);
            }
        }
        return userString.toString();
    }

    private void addUserToBuilder(User user, StringBuilder userString) {
        UserTwitterProperty tid = (UserTwitterProperty)user.getProperty(UserTwitterProperty.class);
        if (tid.getTwitterid() != null) {
            userString.append("@").append(tid.getTwitterid()).append(" ");
        }
    }
}

