/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source.webhook;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.tuleap_git_branch_source.guice.TuleapWebhookGuiceModule;
import org.jenkinsci.plugins.tuleap_git_branch_source.webhook.processor.TuleapWebHookProcessor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class TuleapWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(TuleapWebHook.class.getName());
    static final String WEBHOOK_URL = "tuleap-hook";
    private TuleapWebHookProcessor tuleapWebHookActionProcessor;

    public TuleapWebHook() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapWebhookGuiceModule()});
        this.tuleapWebHookActionProcessor = (TuleapWebHookProcessor)injector.getInstance(TuleapWebHookProcessor.class);
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Process request from Tuleap git repository";
    }

    @CheckForNull
    public String getUrlName() {
        return WEBHOOK_URL;
    }

    public HttpResponse doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        LOGGER.log(Level.FINEST, "Tuleap WebHook called with URL: {0} ", request.getRequestURIWithQueryString());
        return this.tuleapWebHookActionProcessor.process(request);
    }
}

